/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.cmi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import org.objectweb.carol.cmi.ClusterConfig;
import org.objectweb.carol.cmi.ClusterObject;
import org.objectweb.carol.cmi.ClusterRegistry;
import org.objectweb.carol.cmi.ClusterRegistryInternal;
import org.objectweb.carol.cmi.ClusterStubData;
import org.objectweb.carol.cmi.CmiInputStream;
import org.objectweb.carol.cmi.CmiOutputStream;
import org.objectweb.carol.cmi.LowerOrb;
import org.objectweb.carol.util.configuration.TraceCarol;

public class ClusterRegistryClient
implements ClusterRegistry {
    private ClusterRegistryInternal cr;

    public ClusterRegistryClient(ClusterRegistryInternal cr) throws RemoteException {
        this.cr = cr;
    }

    public String[] list() throws RemoteException {
        return this.cr.list();
    }

    public void test() throws RemoteException {
        this.cr.test();
    }

    public Remote lookup(String name) throws NotBoundException, RemoteException {
        Object obj = this.cr.lookup(name);
        if (obj instanceof Remote) {
            return (Remote)obj;
        }
        byte[] buf = (byte[])obj;
        ByteArrayInputStream inStream = new ByteArrayInputStream(buf);
        int type = inStream.read();
        try {
            CmiInputStream in = new CmiInputStream(inStream);
            if (type == 1) {
                return ClusterStubData.read(in, null).getClusterStub();
            }
            return (Remote)in.readObject();
        }
        catch (IOException e) {
            throw new RemoteException(e.toString());
        }
        catch (ClassNotFoundException e) {
            throw new RemoteException(e.toString());
        }
    }

    private byte[] serialize(Remote obj) throws RemoteException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            CmiOutputStream out = new CmiOutputStream(outStream);
            out.writeObject(obj);
            out.flush();
            return outStream.toByteArray();
        }
        catch (IOException e1) {
            throw new RemoteException(e1.toString());
        }
    }

    public void bind(String name, Remote obj) throws AlreadyBoundException, RemoteException {
        ClusterConfig cc;
        block6: {
            cc = null;
            try {
                cc = ClusterObject.getClusterConfig(obj);
                if (TraceCarol.isDebugCmiRegistry()) {
                    TraceCarol.debugCmiRegistry("Global bind of " + name);
                }
            }
            catch (Exception e) {
                if (!TraceCarol.isDebugCmiRegistry()) break block6;
                TraceCarol.debugCmiRegistry("Local bind of " + name);
            }
        }
        if (cc == null) {
            this.cr.bindSingle(name, obj);
        } else {
            if (!cc.isGlobalAtBind()) {
                throw new RemoteException("not implemented");
            }
            obj = LowerOrb.toStub(obj);
            byte[] ser = this.serialize(obj);
            this.cr.bindCluster(name, ser);
        }
    }

    public void rebind(String name, Remote obj) throws RemoteException {
        ClusterConfig cc;
        block6: {
            cc = null;
            try {
                cc = ClusterObject.getClusterConfig(obj);
                if (TraceCarol.isDebugCmiRegistry()) {
                    TraceCarol.debugCmiRegistry("Global bind of " + name);
                }
            }
            catch (Exception e) {
                if (!TraceCarol.isDebugCmiRegistry()) break block6;
                TraceCarol.debugCmiRegistry("Local bind of " + name);
            }
        }
        if (cc == null) {
            this.cr.rebindSingle(name, obj);
        } else {
            if (!cc.isGlobalAtBind()) {
                throw new RemoteException("not implemented");
            }
            obj = LowerOrb.toStub(obj);
            byte[] ser = this.serialize(obj);
            this.cr.rebindCluster(name, ser);
        }
    }

    public void unbind(String name) throws NotBoundException, RemoteException {
        this.cr.unbind(name);
    }
}

