/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.cmi;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import org.objectweb.carol.cmi.ClusterException;
import org.objectweb.carol.cmi.ClusterId;
import org.objectweb.carol.cmi.SecureRandom;

public class ClusterIdFactory {
    private static byte[] localIdArray;
    private static ClusterId localId;
    private static long date;
    private static ServerSocket ss;

    private ClusterIdFactory() {
    }

    public static synchronized void start() throws ClusterException {
        ClusterIdFactory.startTypeIp();
    }

    private static synchronized void startTypeIp() throws ClusterException {
        InetAddress a;
        if (localIdArray != null) {
            return;
        }
        try {
            a = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new ClusterException("Error in getLocalHost() : " + e.toString());
        }
        byte[] aa = a.getAddress();
        if (aa.length != 4) {
            throw new ClusterException("IP Address of size " + aa.length + " not supported by ClusterIdFactory");
        }
        if (aa[0] == 127) {
            throw new ClusterException("Loopback IP address not allowed in ClusterIdFactory : fix /etc/hosts (or equivalent) so that java.net.InetAddress.getLocalHost() does not return 127.x.x.x");
        }
        try {
            ss = new ServerSocket(0, 1, a);
        }
        catch (Exception e) {
            throw new ClusterException(e.toString());
        }
        int p = ss.getLocalPort();
        if ((p & 0xFFFF) != p) {
            throw new ClusterException("Invalid port number (more than 16 bits) in ClusterIdFactory");
        }
        date = System.currentTimeMillis() / 1000L;
        if (date >= 0x80000000L) {
            throw new ClusterException("Invalid date (too high) in ClusterIdFactory");
        }
        localIdArray = new byte[10];
        ClusterIdFactory.localIdArray[0] = (byte)(p & 0xFF);
        ClusterIdFactory.localIdArray[1] = (byte)(p >> 8);
        ClusterIdFactory.localIdArray[2] = aa[3];
        ClusterIdFactory.localIdArray[3] = aa[2];
        ClusterIdFactory.localIdArray[4] = aa[1];
        ClusterIdFactory.localIdArray[5] = aa[0];
        int n = 4;
        long d = date;
        while (n > 0) {
            ClusterIdFactory.localIdArray[9 - --n] = (byte)(d & 0xFFL);
            d >>= 8;
        }
        localId = ClusterId.toClusterId(localIdArray);
        SecureRandom.setSeed(localIdArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static synchronized ClusterId getLocalId() throws ClusterException {
        if (localIdArray == null) {
            ClusterIdFactory.start();
        }
        if (ss == null) {
            return localId;
        }
        while (true) {
            long d;
            if ((d = System.currentTimeMillis()) / 1000L > date) {
                try {
                    ss.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                ss = null;
                return localId;
            }
            try {
                byte[] e = localIdArray;
                // MONITORENTER : localIdArray
                localIdArray.wait(1001L - d % 1000L);
                // MONITOREXIT : e
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            long l = System.currentTimeMillis();
        }
    }
}

