/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.howl.log.xa;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import junit.extensions.RepeatedTest;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.objectweb.howl.log.LogException;
import org.objectweb.howl.log.LogRecord;
import org.objectweb.howl.log.ReplayListener;
import org.objectweb.howl.log.TestDriver;
import org.objectweb.howl.log.xa.XACommittingTx;
import org.objectweb.howl.log.xa.XALogRecord;
import org.objectweb.howl.log.xa.XALogger;
import org.objectweb.howl.log.xa.XAWorker;

public class XALoggerTest
extends TestDriver
implements Comparator {
    XALogger log = null;
    XLTReplayListener openListener = null;
    static final int FAILEDRM = 9000;

    public static void main(String[] args) {
        TestRunner.run((Class)XALoggerTest.class);
    }

    public XALoggerTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.log = new XALogger(this.cfg);
        ((TestDriver)this).log = this.log;
        this.openListener = new XLTReplayListener();
    }

    public void testXALoggerDefaultConstructor() throws Exception {
        this.log = new XALogger();
        ((TestDriver)this).log = this.log;
        this.log.open(this.openListener);
        this.runWorkers(XAWorker.class);
        XALoggerTest.assertEquals((String)"activeTxUsed", (int)0, (int)this.log.getActiveTxUsed());
    }

    public void testXALoggerDefaultConstructor_NewFiles() throws Exception {
        this.deleteLogFiles();
        ((TestDriver)this).log = this.log;
        this.log.open(this.openListener);
        this.runWorkers(XAWorker.class);
        XALoggerTest.assertEquals((String)"activeTxUsed", (int)0, (int)this.log.getActiveTxUsed());
    }

    public void test_001_UnsupportedOpen() throws Exception {
        try {
            this.log.open();
            XALoggerTest.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        XALoggerTest.assertEquals((String)"activeTxUsed", (int)0, (int)this.log.getActiveTxUsed());
    }

    public void test_002_SingleThread() throws Exception {
        this.log.open(this.openListener);
        XALoggerTest.assertEquals((String)"activeTxUsed", (int)0, (int)this.log.getActiveTxUsed());
        this.log.setAutoMark(true);
        this.prop.setProperty("msg.count", "10");
        this.workers = 1;
        this.runWorkers(XAWorker.class);
        XALoggerTest.assertEquals((String)"activeTxUsed", (int)0, (int)this.log.getActiveTxUsed());
    }

    public void test_003_AutoMarkTrue() throws Exception {
        this.log.open(this.openListener);
        XALoggerTest.assertEquals((String)"activeTxUsed", (int)0, (int)this.log.getActiveTxUsed());
        this.log.setAutoMark(true);
        this.runWorkers(XAWorker.class);
        XALoggerTest.assertEquals((String)"activeTxUsed", (int)0, (int)this.log.getActiveTxUsed());
    }

    public void test_010_RMFailure() throws Exception {
        this.log.open(this.openListener);
        XALoggerTest.assertEquals((String)"activeTxUsed after open", (int)0, (int)this.log.getActiveTxUsed());
        this.log.setAutoMark(false);
        XAWorker w = (XAWorker)this.getWorker(XAWorker.class);
        w.setWorkerIndex(9000);
        w.logCommit(1);
        this.log.close();
        XALoggerTest.assertEquals((String)"activeTxUsed", (int)1, (int)this.log.getActiveTxUsed());
    }

    public void test_020_AutoMarkFalseOneDelayedWorker() throws Exception {
        this.log.open(this.openListener);
        this.log.setAutoMark(false);
        XALoggerTest.assertEquals((String)"activeTxUsed", (int)1, (int)this.log.getActiveTxUsed());
        XALoggerTest.assertNull((String)"openListener.exception", (Object)this.openListener.exception);
        this.delayedWorkers = 1;
        this.runWorkers(XAWorker.class);
        XALoggerTest.assertEquals((String)"activeTxUsed", (int)1, (int)this.log.getActiveTxUsed());
    }

    public void test_030_ActiveTxDisplay() throws Exception {
        this.log.open(this.openListener);
        XALoggerTest.assertNull((String)"openListener.exception", (Object)this.openListener.exception);
        XALoggerTest.assertEquals((String)"activeTxUsed", (int)1, (int)this.log.getActiveTxUsed());
        this.log.activeTxDisplay();
        this.log.close();
        XALoggerTest.assertEquals((String)"activeTxUsed", (int)1, (int)this.log.getActiveTxUsed());
    }

    public void test_040_FinishIncompleteTx() throws Exception {
        this.log.open(this.openListener);
        XALoggerTest.assertEquals((String)"activeTxUsed", (int)1, (int)this.log.getActiveTxUsed());
        XALoggerTest.assertNull((String)"openListener.exception", (Object)this.openListener.exception);
        Iterator txSet = this.openListener.activeTx.values().iterator();
        while (txSet.hasNext()) {
            XACommittingTx tx = (XACommittingTx)txSet.next();
            byte[] record = tx.getRecord()[0];
            XALoggerTest.assertEquals((String)"workerID", (String)"[9000.0001]", (String)new String(record, 0, 11));
            byte[] doneRecord = "[9000.0001]DONE\n".getBytes();
            this.log.putDone(new byte[][]{doneRecord}, tx);
        }
        this.log.close();
        XALoggerTest.assertEquals((String)"activeTxUsed", (int)0, (int)this.log.getActiveTxUsed());
    }

    public void test_050_VerifyFinishIncompleteTx() throws Exception {
        this.log.open(this.openListener);
        XALoggerTest.assertNull((String)"openListener.exception", (Object)this.openListener.exception);
        if (this.log.getActiveTxUsed() > 0) {
            this.log.activeTxDisplay();
        }
        this.log.close();
        XALoggerTest.assertEquals((String)"activeTxUsed after close", (int)0, (int)this.log.getActiveTxUsed());
    }

    public void test_060_ReplayFromAutoMark() throws Exception {
        this.log.open(this.openListener);
        XALoggerTest.assertNull((String)"openListener.exception", (Object)this.openListener.exception);
        XLTReplayListener replayListener = new XLTReplayListener();
        this.log.replay(replayListener);
        XALoggerTest.assertNull((String)"replayListener.exception", (Object)replayListener.exception);
        XALoggerTest.assertEquals((String)"activeTxUsed", (int)this.openListener.getActiveTxUsed(), (int)replayListener.getActiveTxUsed());
        this.log.close();
    }

    public void test_061_OpenWithNullReplayListener() throws Exception {
        this.log.open(null);
        this.log.close();
    }

    public void test_070_RMFailure() throws Exception {
        this.log.open(this.openListener);
        this.log.setAutoMark(false);
        XAWorker w = (XAWorker)this.getWorker(XAWorker.class);
        w.setWorkerIndex(9000);
        w.logCommit(1);
        this.log.close();
    }

    public void test_080_ReplayActiveTx() throws Exception {
        this.log.open(this.openListener);
        XALoggerTest.assertNull((String)"openListener.exception", (Object)this.openListener.exception);
        XLTReplayListener replayListener = new XLTReplayListener();
        this.log.replayActiveTx(replayListener);
        this.log.close();
        XALoggerTest.assertNull((String)"replayListener.exception", (Object)replayListener.exception);
        XALoggerTest.assertEquals((String)"activeTxUsed", (int)this.openListener.getActiveTxUsed(), (int)replayListener.getActiveTxUsed());
        XALoggerTest.assertEquals((String)"replayListener.count", (long)replayListener.getActiveTxUsed(), (long)replayListener.count);
    }

    public static Test suite() {
        Method[] methods = XALoggerTest.class.getMethods();
        Arrays.sort(methods, new XALoggerTest(""));
        TestSuite suite = new TestSuite();
        for (int i = 0; i < methods.length; ++i) {
            String name = methods[i].getName();
            if (!name.startsWith("test")) continue;
            suite.addTest((Test)new XALoggerTest(name));
        }
        return new RepeatedTest((Test)suite, Integer.getInteger("XALoggerTest.repeatcount", 1).intValue());
    }

    public int compare(Object a, Object b) {
        return ((Method)a).getName().compareTo(((Method)b).getName());
    }

    private static class XLTReplayListener
    implements ReplayListener {
        public long count = 0L;
        public long commitCount = 0L;
        public long movedCount = 0L;
        public Exception exception = null;
        PrintStream out = null;
        public final HashMap activeTx = new HashMap(64);

        XLTReplayListener() {
        }

        void setPrintStream(PrintStream out) {
            this.out = out;
        }

        private void activeTxPut(XALogRecord lr) {
            byte[] data = lr.getFields()[0];
            String key = new String(data, 1, 9);
            Object o = this.activeTx.remove(key);
            this.activeTx.put(key, lr.getTx());
        }

        private void activeTxRemove(XALogRecord lr) {
            if (lr.getFields().length == 0) {
                return;
            }
            byte[] data = lr.getFields()[0];
            if (lr.dataBuffer.limit() < "[xxxx.xxxx]DONE".length()) {
                return;
            }
            if (!new String(data, 11, 4).equals("DONE")) {
                return;
            }
            String key = new String(data, 1, 9);
            XACommittingTx tx = (XACommittingTx)this.activeTx.remove(key);
        }

        public int getActiveTxUsed() {
            return this.activeTx.size();
        }

        public void onRecord(LogRecord lr) {
            Assert.assertTrue((String)("Expecting XALogRecord, found " + lr.getClass().getName()), (boolean)(lr instanceof XALogRecord));
            ++this.count;
            switch (lr.type) {
                case 19983: {
                    --this.count;
                    break;
                }
                case 16512: {
                    Assert.assertTrue((String)"lr.type", (boolean)lr.isCTRL());
                    Assert.assertTrue((String)"lr.type", (boolean)((XALogRecord)lr).isCommit());
                    ++this.commitCount;
                    this.activeTxPut((XALogRecord)lr);
                    break;
                }
                case 16576: {
                    Assert.assertTrue((String)"lr.type", (boolean)lr.isCTRL());
                    Assert.assertTrue((String)"lr.type", (boolean)((XALogRecord)lr).isCommit());
                    ++this.movedCount;
                    this.activeTxPut((XALogRecord)lr);
                    break;
                }
                default: {
                    Assert.assertFalse((String)("lr.type" + Long.toHexString(lr.type)), (boolean)lr.isCTRL());
                    this.activeTxRemove((XALogRecord)lr);
                }
            }
        }

        public void onError(LogException exception) {
            this.exception = exception;
        }

        public LogRecord getLogRecord() {
            return new XALogRecord(120);
        }
    }
}

