/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.zip;

import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipException;
import org.apache.tools.zip.UnrecognizedExtraField;
import org.apache.tools.zip.ZipExtraField;
import org.apache.tools.zip.ZipShort;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ExtraFieldUtils {
    private static Hashtable implementations = new Hashtable();
    static /* synthetic */ Class class$org$apache$tools$zip$AsiExtraField;

    public static void register(Class clazz) {
        try {
            ZipExtraField zipExtraField = (ZipExtraField)clazz.newInstance();
            implementations.put(zipExtraField.getHeaderId(), clazz);
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException(clazz + " doesn't implement ZipExtraField");
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(clazz + " is not a concrete class");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(clazz + "'s no-arg constructor is not public");
        }
    }

    public static ZipExtraField createExtraField(ZipShort zipShort) throws InstantiationException, IllegalAccessException {
        Class clazz = (Class)implementations.get(zipShort);
        if (clazz != null) {
            return (ZipExtraField)clazz.newInstance();
        }
        UnrecognizedExtraField unrecognizedExtraField = new UnrecognizedExtraField();
        unrecognizedExtraField.setHeaderId(zipShort);
        return unrecognizedExtraField;
    }

    public static ZipExtraField[] parse(byte[] byArray) throws ZipException {
        Object[] objectArray;
        Vector<ZipExtraField> vector = new Vector<ZipExtraField>();
        int n = 0;
        while (n <= byArray.length - 4) {
            objectArray = new ZipShort(byArray, n);
            int n2 = new ZipShort(byArray, n + 2).getValue();
            if (n + 4 + n2 > byArray.length) {
                throw new ZipException("data starting at " + n + " is in unknown format");
            }
            try {
                ZipExtraField zipExtraField = ExtraFieldUtils.createExtraField((ZipShort)objectArray);
                zipExtraField.parseFromLocalFileData(byArray, n + 4, n2);
                vector.addElement(zipExtraField);
            }
            catch (InstantiationException instantiationException) {
                throw new ZipException(instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ZipException(illegalAccessException.getMessage());
            }
            n += n2 + 4;
        }
        if (n != byArray.length) {
            throw new ZipException("data starting at " + n + " is in unknown format");
        }
        objectArray = new ZipExtraField[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static byte[] mergeLocalFileDataData(ZipExtraField[] zipExtraFieldArray) {
        int n = 4 * zipExtraFieldArray.length;
        int n2 = 0;
        while (n2 < zipExtraFieldArray.length) {
            n += zipExtraFieldArray[n2].getLocalFileDataLength().getValue();
            ++n2;
        }
        byte[] byArray = new byte[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < zipExtraFieldArray.length) {
            System.arraycopy(zipExtraFieldArray[n4].getHeaderId().getBytes(), 0, byArray, n3, 2);
            System.arraycopy(zipExtraFieldArray[n4].getLocalFileDataLength().getBytes(), 0, byArray, n3 + 2, 2);
            byte[] byArray2 = zipExtraFieldArray[n4].getLocalFileDataData();
            System.arraycopy(byArray2, 0, byArray, n3 + 4, byArray2.length);
            n3 += byArray2.length + 4;
            ++n4;
        }
        return byArray;
    }

    public static byte[] mergeCentralDirectoryData(ZipExtraField[] zipExtraFieldArray) {
        int n = 4 * zipExtraFieldArray.length;
        int n2 = 0;
        while (n2 < zipExtraFieldArray.length) {
            n += zipExtraFieldArray[n2].getCentralDirectoryLength().getValue();
            ++n2;
        }
        byte[] byArray = new byte[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < zipExtraFieldArray.length) {
            System.arraycopy(zipExtraFieldArray[n4].getHeaderId().getBytes(), 0, byArray, n3, 2);
            System.arraycopy(zipExtraFieldArray[n4].getCentralDirectoryLength().getBytes(), 0, byArray, n3 + 2, 2);
            byte[] byArray2 = zipExtraFieldArray[n4].getCentralDirectoryData();
            System.arraycopy(byArray2, 0, byArray, n3 + 4, byArray2.length);
            n3 += byArray2.length + 4;
            ++n4;
        }
        return byArray;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        Class clazz = class$org$apache$tools$zip$AsiExtraField;
        if (clazz == null) {
            clazz = class$org$apache$tools$zip$AsiExtraField = ExtraFieldUtils.class("[Lorg.apache.tools.zip.AsiExtraField;", false);
        }
        ExtraFieldUtils.register(clazz);
    }
}

