/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.util.Properties;
import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.CompositeMapper;
import org.apache.tools.ant.util.ContainerMapper;
import org.apache.tools.ant.util.FileNameMapper;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Mapper
extends DataType
implements Cloneable {
    protected MapperType type;
    protected String classname;
    protected Path classpath;
    protected String from;
    protected String to;
    private ContainerMapper container;

    public void setType(MapperType mapperType) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.type = mapperType;
    }

    public void add(FileNameMapper fileNameMapper) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.container == null) {
            if (this.type == null && this.classname == null) {
                this.container = new CompositeMapper();
            } else {
                FileNameMapper fileNameMapper2 = this.getImplementation();
                if (fileNameMapper2 instanceof ContainerMapper) {
                    this.container = (ContainerMapper)fileNameMapper2;
                } else {
                    throw new BuildException(String.valueOf(fileNameMapper2) + " mapper implementation does not support nested mappers!");
                }
            }
        }
        this.container.add(fileNameMapper);
    }

    public void addConfiguredMapper(Mapper mapper) {
        this.add(mapper.getImplementation());
    }

    public void setClassname(String string) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.classname = string;
    }

    public void setClasspath(Path path) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createClasspath().setRefid(reference);
    }

    public void setFrom(String string) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.from = string;
    }

    public void setTo(String string) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.to = string;
    }

    public void setRefid(Reference reference) throws BuildException {
        if (this.type != null || this.from != null || this.to != null) {
            throw this.tooManyAttributes();
        }
        super.setRefid(reference);
    }

    public FileNameMapper getImplementation() throws BuildException {
        if (this.isReference()) {
            return this.getRef().getImplementation();
        }
        if (this.type == null && this.classname == null && this.container == null) {
            throw new BuildException("nested mapper or one of the attributes type or classname is required");
        }
        if (this.container != null) {
            return this.container;
        }
        if (this.type != null && this.classname != null) {
            throw new BuildException("must not specify both type and classname attribute");
        }
        try {
            FileNameMapper fileNameMapper = (FileNameMapper)this.getImplementationClass().newInstance();
            Project project = this.getProject();
            if (project != null) {
                project.setProjectReference(fileNameMapper);
            }
            fileNameMapper.setFrom(this.from);
            fileNameMapper.setTo(this.to);
            return fileNameMapper;
        }
        catch (BuildException buildException) {
            throw buildException;
        }
        catch (Throwable throwable) {
            throw new BuildException(throwable);
        }
    }

    protected Class getImplementationClass() throws ClassNotFoundException {
        String string = this.classname;
        if (this.type != null) {
            string = this.type.getImplementation();
        }
        ClassLoader classLoader = this.classpath == null ? this.getClass().getClassLoader() : this.getProject().createClassLoader(this.classpath);
        return Class.forName(string, true, classLoader);
    }

    protected Mapper getRef() {
        Object object;
        if (!this.isChecked()) {
            object = new Stack<Mapper>();
            ((Stack)object).push(this);
            this.dieOnCircularReference((Stack)object, this.getProject());
        }
        if (!((object = this.getRefid().getReferencedObject(this.getProject())) instanceof Mapper)) {
            String string = this.getRefid().getRefId() + " doesn't denote a mapper";
            throw new BuildException(string);
        }
        return (Mapper)object;
    }

    private final /* synthetic */ void this() {
        this.type = null;
        this.classname = null;
        this.classpath = null;
        this.from = null;
        this.to = null;
        this.container = null;
    }

    public Mapper(Project project) {
        this.this();
        this.setProject(project);
    }

    public static class MapperType
    extends EnumeratedAttribute {
        private Properties implementations = new Properties();

        public String[] getValues() {
            return new String[]{"identity", "flatten", "glob", "merge", "regexp", "package", "unpackage"};
        }

        public String getImplementation() {
            return this.implementations.getProperty(this.getValue());
        }

        public MapperType() {
            this.implementations.put("identity", "org.apache.tools.ant.util.IdentityMapper");
            this.implementations.put("flatten", "org.apache.tools.ant.util.FlatFileNameMapper");
            this.implementations.put("glob", "org.apache.tools.ant.util.GlobPatternMapper");
            this.implementations.put("merge", "org.apache.tools.ant.util.MergingMapper");
            this.implementations.put("regexp", "org.apache.tools.ant.util.RegexpPatternMapper");
            this.implementations.put("package", "org.apache.tools.ant.util.PackageNameMapper");
            this.implementations.put("unpackage", "org.apache.tools.ant.util.UnPackageNameMapper");
        }
    }
}

