/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.rmic.RmicAdapter;
import org.apache.tools.ant.taskdefs.rmic.RmicAdapterFactory;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.SourceFileScanner;
import org.apache.tools.ant.util.facade.FacadeTaskHelper;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Rmic
extends MatchingTask {
    private static final String FAIL_MSG = "Rmic failed; see the compiler error output for details.";
    private File baseDir;
    private String classname;
    private File sourceBase;
    private String stubVersion;
    private Path compileClasspath;
    private Path extdirs;
    private boolean verify;
    private boolean filtering;
    private boolean iiop;
    private String iiopopts;
    private boolean idl;
    private String idlopts;
    private boolean debug;
    private boolean includeAntRuntime;
    private boolean includeJavaRuntime;
    private Vector compileList;
    private ClassLoader loader;
    private FileUtils fileUtils;
    private FacadeTaskHelper facade;
    static /* synthetic */ Class class$java$rmi$Remote;

    public void setBase(File file) {
        this.baseDir = file;
    }

    public File getBase() {
        return this.baseDir;
    }

    public void setClassname(String string) {
        this.classname = string;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setSourceBase(File file) {
        this.sourceBase = file;
    }

    public File getSourceBase() {
        return this.sourceBase;
    }

    public void setStubVersion(String string) {
        this.stubVersion = string;
    }

    public String getStubVersion() {
        return this.stubVersion;
    }

    public void setFiltering(boolean bl) {
        this.filtering = bl;
    }

    public boolean getFiltering() {
        return this.filtering;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setClasspath(Path path) {
        if (this.compileClasspath == null) {
            this.compileClasspath = path;
        } else {
            this.compileClasspath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.getProject());
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public Path getClasspath() {
        return this.compileClasspath;
    }

    public void setVerify(boolean bl) {
        this.verify = bl;
    }

    public boolean getVerify() {
        return this.verify;
    }

    public void setIiop(boolean bl) {
        this.iiop = bl;
    }

    public boolean getIiop() {
        return this.iiop;
    }

    public void setIiopopts(String string) {
        this.iiopopts = string;
    }

    public String getIiopopts() {
        return this.iiopopts;
    }

    public void setIdl(boolean bl) {
        this.idl = bl;
    }

    public boolean getIdl() {
        return this.idl;
    }

    public void setIdlopts(String string) {
        this.idlopts = string;
    }

    public String getIdlopts() {
        return this.idlopts;
    }

    public Vector getFileList() {
        return this.compileList;
    }

    public void setIncludeantruntime(boolean bl) {
        this.includeAntRuntime = bl;
    }

    public boolean getIncludeantruntime() {
        return this.includeAntRuntime;
    }

    public void setIncludejavaruntime(boolean bl) {
        this.includeJavaRuntime = bl;
    }

    public boolean getIncludejavaruntime() {
        return this.includeJavaRuntime;
    }

    public void setExtdirs(Path path) {
        if (this.extdirs == null) {
            this.extdirs = path;
        } else {
            this.extdirs.append(path);
        }
    }

    public Path createExtdirs() {
        if (this.extdirs == null) {
            this.extdirs = new Path(this.getProject());
        }
        return this.extdirs.createPath();
    }

    public Path getExtdirs() {
        return this.extdirs;
    }

    public Vector getCompileList() {
        return this.compileList;
    }

    public void setCompiler(String string) {
        this.facade.setImplementation(string);
    }

    public String getCompiler() {
        this.facade.setMagicValue(this.getProject().getProperty("build.rmic"));
        return this.facade.getImplementation();
    }

    public ImplementationSpecificArgument createCompilerArg() {
        ImplementationSpecificArgument implementationSpecificArgument = new ImplementationSpecificArgument();
        this.facade.addImplementationArgument(implementationSpecificArgument);
        return implementationSpecificArgument;
    }

    public String[] getCurrentCompilerArgs() {
        this.getCompiler();
        return this.facade.getArgs();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        if (this.baseDir == null) {
            throw new BuildException("base attribute must be set!", this.getLocation());
        }
        if (!this.baseDir.exists()) {
            throw new BuildException("base does not exist!", this.getLocation());
        }
        if (this.verify) {
            this.log("Verify has been turned on.", 3);
        }
        RmicAdapter rmicAdapter = RmicAdapterFactory.getRmic(this.getCompiler(), this);
        rmicAdapter.setRmic(this);
        Path path = rmicAdapter.getClasspath();
        this.loader = this.getProject().createClassLoader(path);
        try {
            if (this.classname == null) {
                DirectoryScanner directoryScanner = this.getDirectoryScanner(this.baseDir);
                String[] stringArray = directoryScanner.getIncludedFiles();
                this.scanDir(this.baseDir, stringArray, rmicAdapter.getMapper());
            } else {
                this.scanDir(this.baseDir, new String[]{this.classname.replace('.', File.separatorChar) + ".class"}, rmicAdapter.getMapper());
            }
            int n = this.compileList.size();
            if (n > 0) {
                this.log("RMI Compiling " + n + " class" + (n > 1 ? "es" : "") + " to " + this.baseDir, 2);
                if (!rmicAdapter.execute()) {
                    throw new BuildException(FAIL_MSG, this.getLocation());
                }
            }
            if (this.sourceBase != null && !this.baseDir.equals(this.sourceBase) && n > 0) {
                if (this.idl) {
                    this.log("Cannot determine sourcefiles in idl mode, ", 1);
                    this.log("sourcebase attribute will be ignored.", 1);
                } else {
                    int n2 = 0;
                    while (n2 < n) {
                        this.moveGeneratedFile(this.baseDir, this.sourceBase, (String)this.compileList.elementAt(n2), rmicAdapter);
                        ++n2;
                    }
                }
            }
            Object var4_9 = null;
            this.compileList.removeAllElements();
            return;
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.compileList.removeAllElements();
            throw throwable;
        }
    }

    private final void moveGeneratedFile(File file, File file2, String string, RmicAdapter rmicAdapter) throws BuildException {
        String string2 = string.replace('.', File.separatorChar) + ".class";
        String[] stringArray = rmicAdapter.getMapper().mapFileName(string2);
        int n = 0;
        while (n < stringArray.length) {
            int n2;
            String string3;
            File file3;
            String string4 = stringArray[n];
            if (string4.endsWith(".class") && (file3 = new File(file, string3 = string4.substring(0, n2 = string4.length() - ".class".length()) + ".java")).exists()) {
                File file4 = new File(file2, string3);
                try {
                    if (this.filtering) {
                        this.fileUtils.copyFile(file3, file4, new FilterSetCollection(this.getProject().getGlobalFilterSet()));
                    } else {
                        this.fileUtils.copyFile(file3, file4);
                    }
                    file3.delete();
                }
                catch (IOException iOException) {
                    String string5 = "Failed to copy " + file3 + " to " + file4 + " due to " + iOException.getMessage();
                    throw new BuildException(string5, iOException, this.getLocation());
                }
            }
            ++n;
        }
    }

    protected void scanDir(File file, String[] stringArray, FileNameMapper fileNameMapper) {
        String[] stringArray2 = stringArray;
        if (this.idl) {
            this.log("will leave uptodate test to rmic implementation in idl mode.", 3);
        } else if (this.iiop && this.iiopopts != null && this.iiopopts.indexOf("-always") > -1) {
            this.log("no uptodate test as -always option has been specified", 3);
        } else {
            SourceFileScanner sourceFileScanner = new SourceFileScanner(this);
            stringArray2 = sourceFileScanner.restrict(stringArray, file, file, fileNameMapper);
        }
        int n = 0;
        while (n < stringArray2.length) {
            String string = stringArray2[n].replace(File.separatorChar, '.');
            string = string.substring(0, string.lastIndexOf(".class"));
            this.compileList.addElement(string);
            ++n;
        }
    }

    public boolean isValidRmiRemote(String string) {
        try {
            Class<?> clazz = this.loader.loadClass(string);
            if (clazz.isInterface() && !this.iiop && !this.idl) {
                return false;
            }
            return this.isValidRmiRemote(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log("Unable to verify class " + string + ". It could not be found.", 1);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.log("Unable to verify class " + string + ". It is not defined.", 1);
        }
        catch (Throwable throwable) {
            this.log("Unable to verify class " + string + ". Loading caused Exception: " + throwable.getMessage(), 1);
        }
        return false;
    }

    public Class getRemoteInterface(Class clazz) {
        Class<?>[] classArray;
        Class clazz2 = class$java$rmi$Remote;
        if (clazz2 == null) {
            clazz2 = class$java$rmi$Remote = Rmic.class("[Ljava.rmi.Remote;", false);
        }
        if (clazz2.isAssignableFrom(clazz) && (classArray = clazz.getInterfaces()) != null) {
            int n = 0;
            while (n < classArray.length) {
                Class clazz3 = class$java$rmi$Remote;
                if (clazz3 == null) {
                    clazz3 = Rmic.class("[Ljava.rmi.Remote;", false);
                }
                if (clazz3.isAssignableFrom(classArray[n])) {
                    return classArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    private final boolean isValidRmiRemote(Class clazz) {
        boolean bl = false;
        if (this.getRemoteInterface(clazz) != null) {
            bl = true;
        }
        return bl;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.verify = false;
        this.filtering = false;
        this.iiop = false;
        this.idl = false;
        this.debug = false;
        this.includeAntRuntime = true;
        this.includeJavaRuntime = false;
        this.compileList = new Vector();
        this.loader = null;
        this.fileUtils = FileUtils.newFileUtils();
    }

    public Rmic() {
        this.this();
        try {
            Class.forName("kaffe.rmi.rmic.RMIC");
            this.facade = new FacadeTaskHelper("kaffe");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.facade = new FacadeTaskHelper("sun");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ImplementationSpecificArgument
    extends org.apache.tools.ant.util.facade.ImplementationSpecificArgument {
        public void setCompiler(String string) {
            super.setImplementation(string);
        }
    }
}

