/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.j2ee.session;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.jboss.logging.Logger;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RpcDispatcher;
import org.mortbay.j2ee.session.AbstractReplicatedStore;
import org.mortbay.j2ee.session.LocalState;
import org.mortbay.j2ee.session.MarshallingInterceptor;

public class JGStore
extends AbstractReplicatedStore
implements MessageListener,
MembershipListener {
    protected Logger _log = Logger.getLogger((Class)(class$org$mortbay$j2ee$session$JGStore == null ? (class$org$mortbay$j2ee$session$JGStore = JGStore.class$("org.mortbay.j2ee.session.JGStore")) : class$org$mortbay$j2ee$session$JGStore));
    protected String _protocolStack = "UDP(mcast_addr=228.8.8.8;mcast_port=45566;ip_ttl=32;ucast_recv_buf_size=16000;ucast_send_buf_size=16000;mcast_send_buf_size=32000;mcast_recv_buf_size=64000;loopback=true):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.STABLE(desired_avg_gossip=20000):pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800;max_xmit_size=8192):UNICAST(timeout=2000):FRAG(frag_size=8192;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true):pbcast.STATE_TRANSFER";
    protected String _subClusterName = "DefaultSubCluster";
    protected int _retrievalTimeOut = 20000;
    protected int _distributionModeInternal = 2;
    protected String _distributionMode = "GET_ALL";
    protected int _distributionTimeOut = 5000;
    protected Channel _channel;
    protected RpcDispatcher _dispatcher;
    protected Vector _members;
    protected Object _idsLock = new Object();
    protected Set _ids = new HashSet();
    protected Timer _timer = new Timer();
    protected long _period = 0L;
    static /* synthetic */ Class class$org$mortbay$j2ee$session$JGStore;
    static /* synthetic */ Class class$org$jgroups$blocks$GroupRequest;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public String getProtocolStack() {
        return this._protocolStack;
    }

    public void setProtocolStack(String protocolStack) {
        this._protocolStack = protocolStack;
    }

    public String getSubClusterName() {
        return this._subClusterName;
    }

    public void setSubClusterName(String subClusterName) {
        this._subClusterName = subClusterName;
    }

    public int getRetrievalTimeOut() {
        return this._retrievalTimeOut;
    }

    public void setRetrievalTimeOut(int retrievalTimeOut) {
        this._retrievalTimeOut = retrievalTimeOut;
    }

    protected int getDistributionModeInternal() {
        return this._distributionModeInternal;
    }

    protected void setDistributionModeInternal(String distributionMode) {
        try {
            this._distributionModeInternal = (class$org$jgroups$blocks$GroupRequest == null ? (class$org$jgroups$blocks$GroupRequest = JGStore.class$("org.jgroups.blocks.GroupRequest")) : class$org$jgroups$blocks$GroupRequest).getDeclaredField(distributionMode).getInt(class$org$jgroups$blocks$GroupRequest == null ? (class$org$jgroups$blocks$GroupRequest = JGStore.class$("org.jgroups.blocks.GroupRequest")) : class$org$jgroups$blocks$GroupRequest);
        }
        catch (Exception e) {
            this._log.error((Object)("could not convert " + distributionMode + " to GroupRequest field"), (Throwable)e);
        }
    }

    public String getDistributionMode() {
        return this._distributionMode;
    }

    public void setDistributionMode(String distributionMode) {
        this._distributionMode = distributionMode;
        this.setDistributionModeInternal(this._distributionMode);
    }

    public int getDistributionTimeOut() {
        return this._distributionTimeOut;
    }

    public void setDistributionTimeOut(int distributionTimeOut) {
        this._distributionTimeOut = distributionTimeOut;
    }

    public Object clone() {
        this._log.trace((Object)"cloning...");
        JGStore jgs = (JGStore)super.clone();
        jgs.setProtocolStack(this.getProtocolStack());
        jgs.setSubClusterName(this.getSubClusterName());
        jgs.setRetrievalTimeOut(this.getRetrievalTimeOut());
        jgs.setDistributionMode(this.getDistributionMode());
        jgs.setDistributionTimeOut(this.getDistributionTimeOut());
        this._log.trace((Object)"...cloned");
        return jgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getMembers() {
        Address[] addresses;
        Vector vector = this._members;
        synchronized (vector) {
            addresses = this._members.toArray(new Address[this._members.size()]);
        }
        String[] members = new String[1 + addresses.length];
        members[0] = this._channel.getLocalAddress().toString();
        for (int i = 0; i < addresses.length; ++i) {
            members[1 + i] = addresses[i].toString();
        }
        return members;
    }

    protected void init() {
        this._log = Logger.getLogger((String)((class$org$mortbay$j2ee$session$JGStore == null ? (class$org$mortbay$j2ee$session$JGStore = JGStore.class$("org.mortbay.j2ee.session.JGStore")) : class$org$mortbay$j2ee$session$JGStore).getName() + "#" + this.getContextPath()));
        this._log.trace((Object)"initialising...");
        try {
            this._channel = new JChannel(this.getProtocolStack());
            JGStore messageListener = this;
            JGStore membershipListener = this;
            JGStore serverObject = this;
            this._dispatcher = new RpcDispatcher(this._channel, (MessageListener)messageListener, (MembershipListener)membershipListener, (Object)serverObject);
            this._dispatcher.setMarshaller(new RpcDispatcher.Marshaller(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object objectFromByteBuffer(byte[] buf) {
                    ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(JGStore.this.getLoader());
                        Object object = MarshallingInterceptor.demarshal(buf);
                        return object;
                    }
                    catch (Exception e) {
                        JGStore.this._log.error((Object)"could not demarshal incoming update", (Throwable)e);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(oldLoader);
                    }
                    return null;
                }

                public byte[] objectToByteBuffer(Object obj) {
                    try {
                        return MarshallingInterceptor.marshal(obj);
                    }
                    catch (Exception e) {
                        JGStore.this._log.error((Object)"could not marshal outgoing update", (Throwable)e);
                        return null;
                    }
                }
            });
            this._log.debug((Object)"JGroups RpcDispatcher initialised");
            this._channel.setOpt(4, (Object)Boolean.TRUE);
            this._log.debug((Object)"JGroups Channel initialised");
            View view = this._channel.getView();
            if (view != null) {
                this._members = (Vector)view.getMembers().clone();
            }
            Vector vector = this._members = this._members == null ? new Vector() : (Vector)this._members.clone();
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("JGroups View: " + this._members));
            }
            this._members.remove(this._channel.getLocalAddress());
        }
        catch (Exception e) {
            this._log.error((Object)"could not initialise JGroups Channel and Dispatcher", (Throwable)e);
        }
        this._log.trace((Object)"...initialised");
    }

    public String getChannelName() {
        return "JETTY_HTTPSESSION_DISTRIBUTION:" + this.getContextPath() + "-" + this.getSubClusterName();
    }

    public void start() throws Exception {
        this._log.trace((Object)"starting...");
        this._log.info((Object)("starting JGroups " + Version.version));
        super.start();
        this.init();
        String channelName = this.getChannelName();
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("starting JGroups...: (" + channelName + ")"));
        }
        this._channel.connect(channelName);
        this._log.trace((Object)"JGroups Channel connected");
        this._dispatcher.start();
        this._log.trace((Object)"JGroups Dispatcher started");
        if (!this._channel.getState(null, (long)this.getRetrievalTimeOut())) {
            this._log.info((Object)"cluster state is null - this must be the first node");
        }
        this._log.debug((Object)"...JGroups started");
        this._log.trace((Object)"...started");
    }

    public void stop() {
        this._log.trace((Object)"stopping...");
        this._timer.cancel();
        this._log.trace((Object)"Touch Timer stopped");
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("stopping JGroups...: (" + this.getChannelName() + ")"));
        }
        this._dispatcher.stop();
        this._log.trace((Object)"JGroups RpcDispatcher stopped");
        this._channel.disconnect();
        this._log.trace((Object)"JGroups Channel disconnected");
        this._log.debug((Object)"...JGroups stopped");
        super.stop();
        this._log.trace((Object)"...stopped");
    }

    public void destroy() {
        this._log.trace((Object)"destroying...");
        this._timer = null;
        this._dispatcher = null;
        this._channel = null;
        super.destroy();
        this._log.trace((Object)"...destroyed");
    }

    public long getBatchPeriod() {
        return this._period;
    }

    public void setBatchPeriod(long period) {
        this._period = period;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publish(String id, Method method, Object[] argInstances) {
        Class[] tmp;
        Object args;
        if (this._log.isTraceEnabled()) {
            args = "";
            for (int i = 0; i < argInstances.length; ++i) {
                args = (String)args + (i > 0 ? "," : "") + argInstances[i];
            }
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("publishing method...: " + id + "." + method.getName() + "(" + (String)args + ")"));
            }
        }
        if (this._period > 0L) {
            if (method.equals(SET_LAST_ACCESSED_TIME)) {
                args = this._idsLock;
                synchronized (args) {
                    if (this._ids.size() == 0) {
                        this._timer.schedule((TimerTask)new TouchTimerTask(), this._period);
                        this._log.debug((Object)"Touch Timer scheduled: _period");
                    }
                    this._ids.add(id);
                }
                return;
            }
            if (method.equals(DESTROY_SESSION)) {
                tmp = (Class[])argInstances[0];
                Object i = this._idsLock;
                synchronized (i) {
                    this._ids.remove(tmp);
                }
            }
        }
        try {
            tmp = new Class[]{class$java$lang$String == null ? (class$java$lang$String = JGStore.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Integer == null ? (class$java$lang$Integer = JGStore.class$("java.lang.Integer")) : class$java$lang$Integer, array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = JGStore.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object};
            MethodCall mc = new MethodCall(this.getClass().getMethod("dispatch", tmp));
            Object[] args2 = new Object[]{id, _methodToInteger.get(method.getName()), argInstances};
            mc.setArgs(args2);
            this._dispatcher.callRemoteMethods(this._members, mc, this.getDistributionModeInternal(), (long)this.getDistributionTimeOut());
            this._log.trace((Object)"...method published");
        }
        catch (Exception e) {
            this._log.error((Object)"problem publishing change in state over JGroups", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(String id, Integer method, Object[] argInstances) {
        Method m = _integerToMethod[method];
        if (this._log.isTraceEnabled()) {
            String args = "";
            for (int i = 0; i < argInstances.length; ++i) {
                args = args + (i > 0 ? "," : "") + argInstances[i];
            }
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("dispatching method... : " + id + "." + _integerToMethod[method].getName() + "(" + args + ")"));
            }
        }
        if (m.equals(DESTROY_SESSION)) {
            String tmp = (String)argInstances[0];
            Object object = this._idsLock;
            synchronized (object) {
                this._ids.remove(tmp);
            }
        }
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getLoader());
            super.dispatch(id, method, argInstances);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
        this._log.trace((Object)"...method dispatched");
    }

    public void receive(Message msg) {
        byte[] buf = msg.getBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] getState() {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            LocalState[] state;
            Thread.currentThread().setContextClassLoader(this.getLoader());
            this._log.info((Object)"initialising another store from our current state");
            Map map = this._sessions;
            synchronized (map) {
                this._log.info((Object)("sending " + this._sessions.size() + " sessions"));
                state = new LocalState[this._sessions.size()];
                int j = 0;
                Iterator i = this._sessions.values().iterator();
                while (i.hasNext()) {
                    state[j++] = (LocalState)i.next();
                }
            }
            Object[] data = new Object[]{new Long(System.currentTimeMillis()), state};
            try {
                byte[] j = MarshallingInterceptor.marshal(data);
                return j;
            }
            catch (Exception e) {
                this._log.error((Object)"Unable to getState from JGroups: ", (Throwable)e);
                byte[] byArray = null;
                Thread.currentThread().setContextClassLoader(oldLoader);
                return byArray;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setState(byte[] tmp) {
        if (tmp != null) {
            this._log.info((Object)"initialising our state from another Store");
            Object[] data = null;
            try {
                data = (Object[])MarshallingInterceptor.demarshal(tmp);
            }
            catch (Exception e) {
                this._log.error((Object)"Unable to setState from JGroups: ", (Throwable)e);
                return;
            }
            try {
                AbstractReplicatedStore.setReplicating(true);
                long remoteTime = (Long)data[0];
                long localTime = System.currentTimeMillis();
                long disparity = (localTime - remoteTime) / 1000L;
                this._log.info((Object)("time disparity: " + disparity + " secs"));
                LocalState[] state = (LocalState[])data[1];
                this._log.info((Object)("receiving " + state.length + " sessions..."));
                for (int i = 0; i < state.length; ++i) {
                    LocalState ls = state[i];
                    this._sessions.put(ls.getId(), ls);
                    this.getManager().getHttpSession(ls.getId());
                }
            }
            finally {
                AbstractReplicatedStore.setReplicating(false);
            }
        }
    }

    public void block() {
        this._log.trace((Object)"handling JGroups block()...");
        this._log.trace((Object)"...JGroups block() handled");
    }

    public synchronized void suspect(Address suspected_mbr) {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("handling JGroups suspect(" + suspected_mbr + ")..."));
        }
        this._log.warn((Object)("cluster suspects member may have been lost: " + suspected_mbr));
        this._log.trace((Object)"...JGroups suspect() handled");
    }

    public synchronized void viewAccepted(View newView) {
        Vector newMembers;
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("handling JGroups viewAccepted(" + newView + ")..."));
        }
        if (newView instanceof MergeView) {
            this._log.warn((Object)("NYI - merging: view is " + newView));
        }
        if ((newMembers = newView.getMembers()) != null) {
            this._members.clear();
            this._members.addAll(newMembers);
            this._log.info((Object)("JGroups View: " + this._members));
            this._members.remove(this._channel.getLocalAddress());
        }
        this._log.trace((Object)"...JGroups viewAccepted() handled");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class TouchTimerTask
    extends TimerTask {
        protected Set _oldIds = null;
        protected Set _newIds = new HashSet();

        protected TouchTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = JGStore.this._idsLock;
            synchronized (object) {
                this._oldIds = JGStore.this._ids;
                JGStore.this._ids = this._newIds;
                this._newIds = null;
            }
            JGStore.this.publish(null, AbstractReplicatedStore.TOUCH_SESSIONS, new Object[]{this._oldIds.toArray(new String[this._oldIds.size()]), new Long(System.currentTimeMillis() + JGStore.this._period)});
            this._oldIds.clear();
            this._newIds = this._oldIds;
            this._oldIds = null;
        }
    }
}

