/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.rmi.jrmp.interceptor;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Iterator;
import org.objectweb.carol.rmi.jrmp.interceptor.JClientRequestInfo;
import org.objectweb.carol.rmi.jrmp.interceptor.JClientRequestInterceptor;
import org.objectweb.carol.rmi.jrmp.interceptor.JContextStore;
import org.objectweb.carol.rmi.jrmp.interceptor.JInterceptorHelper;
import org.objectweb.carol.rmi.jrmp.interceptor.JRMPClientRequestInfoImpl;
import org.objectweb.carol.rmi.jrmp.interceptor.JServiceContext;
import org.objectweb.carol.util.configuration.TraceCarol;

public class JClientInterceptorHelper
extends JInterceptorHelper {
    public static void send_request(ObjectOutput out, JClientRequestInterceptor[] cis, boolean localRef) throws IOException {
        if (cis == null || cis.length == 0) {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JClientInterceptorHelper send request without interceptors");
            }
            out.writeInt(0);
        } else {
            JRMPClientRequestInfoImpl jrc = new JRMPClientRequestInfoImpl();
            int i = 0;
            while (i < cis.length) {
                cis[i].send_request(jrc);
                ++i;
            }
            JClientInterceptorHelper.setClientContextInOutput(out, jrc, localRef);
        }
        out.flush();
    }

    public static void send_poll(ObjectOutput out, JClientRequestInterceptor[] cis, boolean localRef) throws IOException {
    }

    public static void receive_reply(ObjectInput in, JClientRequestInterceptor[] cis) throws IOException {
        try {
            int ctxValue = in.readInt();
            JRMPClientRequestInfoImpl jrc = new JRMPClientRequestInfoImpl();
            if (cis == null || cis.length == 0) {
                if (TraceCarol.isDebugRmiCarol()) {
                    TraceCarol.debugRmiCarol("JClientInterceptorHelper receive reply without interceptors");
                }
                JClientInterceptorHelper.getClientRequestContextFromInput(in, ctxValue, jrc);
            } else {
                if (TraceCarol.isDebugRmiCarol()) {
                    TraceCarol.debugRmiCarol("JClientInterceptorHelper receive reply contexts");
                }
                JClientRequestInfo ri = JClientInterceptorHelper.getClientRequestContextFromInput(in, ctxValue, jrc);
                int i = 0;
                while (i < cis.length) {
                    cis[i].receive_reply(ri);
                    ++i;
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("" + cnfe);
        }
    }

    public static void receive_exception(ObjectInput in, JClientRequestInterceptor[] cis) throws IOException {
        try {
            int ctxValue = in.readInt();
            JRMPClientRequestInfoImpl jrc = new JRMPClientRequestInfoImpl();
            if (cis == null || cis.length == 0) {
                if (TraceCarol.isDebugRmiCarol()) {
                    TraceCarol.debugRmiCarol("JClientInterceptorHelper receive exception without interceptors");
                }
                JClientInterceptorHelper.getClientRequestContextFromInput(in, ctxValue, jrc);
            } else {
                if (TraceCarol.isDebugRmiCarol()) {
                    TraceCarol.debugRmiCarol("JClientInterceptorHelper receive exception contexts");
                }
                JClientRequestInfo ri = JClientInterceptorHelper.getClientRequestContextFromInput(in, ctxValue, jrc);
                int i = 0;
                while (i < cis.length) {
                    cis[i].receive_exception(ri);
                    ++i;
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("" + cnfe);
        }
    }

    public static void receive_other(ObjectInput in, JClientRequestInterceptor[] cis) throws IOException {
        try {
            int ctxValue = in.readInt();
            JRMPClientRequestInfoImpl jrc = new JRMPClientRequestInfoImpl();
            if (cis == null || cis.length == 0) {
                if (TraceCarol.isDebugRmiCarol()) {
                    TraceCarol.debugRmiCarol("JClientInterceptorHelper receive other without interceptors");
                }
                JClientInterceptorHelper.getClientRequestContextFromInput(in, ctxValue, jrc);
            } else {
                if (TraceCarol.isDebugRmiCarol()) {
                    TraceCarol.debugRmiCarol("JClientInterceptorHelper receive other contexts");
                }
                JClientRequestInfo ri = JClientInterceptorHelper.getClientRequestContextFromInput(in, ctxValue, jrc);
                int i = 0;
                while (i < cis.length) {
                    cis[i].receive_other(ri);
                    ++i;
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("" + cnfe);
        }
    }

    public static JClientRequestInfo getClientRequestContextFromInput(ObjectInput in, int ctxValue, JClientRequestInfo jrc) throws ClassNotFoundException, IOException {
        if (ctxValue == 0) {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JClientInterceptorHelper getObjectFromInput no context");
            }
            return jrc;
        }
        if (ctxValue == 1) {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JClientInterceptorHelper getObjectFromInput remote");
            }
            int sz = in.readInt();
            int i = 0;
            while (i < sz) {
                jrc.add_request_service_context((JServiceContext)in.readObject());
                ++i;
            }
            return jrc;
        }
        if (ctxValue == 2) {
            int id = in.readInt();
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JClientInterceptorHelper getObjectFromInput local id(" + id + ")");
            }
            jrc.add_all_request_service_context((Collection)JContextStore.getObject(id));
            return jrc;
        }
        throw new IOException("Unknow context type:" + ctxValue);
    }

    public static void setClientContextInOutput(ObjectOutput out, JClientRequestInfo ri, boolean locRef) throws IOException {
        block6: {
            block7: {
                block5: {
                    if (ri.hasContexts()) break block5;
                    if (TraceCarol.isDebugRmiCarol()) {
                        TraceCarol.debugRmiCarol("JClientInterceptorHelper send request without contexts");
                    }
                    out.writeInt(0);
                    break block6;
                }
                if (!locRef) break block7;
                Collection ctx = ri.get_all_request_service_context();
                int k = JContextStore.storeObject(ctx);
                out.writeInt(2);
                out.writeInt(k);
                if (!TraceCarol.isDebugRmiCarol()) break block6;
                TraceCarol.debugRmiCarol("JClientInterceptorHelper send request with local contexts id(" + k + ")");
                Iterator i = ctx.iterator();
                while (i.hasNext()) {
                    TraceCarol.debugRmiCarol("ctx:" + i.next());
                }
                break block6;
            }
            out.writeInt(1);
            Collection allCtx = ri.get_all_request_service_context();
            out.writeInt(allCtx.size());
            Iterator i = allCtx.iterator();
            while (i.hasNext()) {
                out.writeObject(i.next());
            }
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JClientInterceptorHelper send request with remote contexts");
                Iterator i2 = allCtx.iterator();
                while (i2.hasNext()) {
                    TraceCarol.debugRmiCarol("ctx:" + i2.next());
                }
            }
        }
    }
}

