/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.cmi.compiler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.objectweb.carol.cmi.compiler.Compiler;
import org.objectweb.carol.cmi.compiler.CompilerException;
import org.objectweb.carol.cmi.compiler.RunnableStreamListener;

public class Utils {
    static void compileFile(Compiler cCtx, String fullFileName) throws CompilerException {
        int n;
        Process proc;
        String command = cCtx.getCompiler() + " -d " + cCtx.getDestDir() + " " + fullFileName;
        String classpath = "";
        classpath = cCtx.getClassPath() != null ? cCtx.getClassPath() + System.getProperty("path.separator", "") + System.getProperty("java.class.path", "") : System.getProperty("java.class.path", "");
        String[] env = new String[]{"CLASSPATH=" + classpath};
        try {
            proc = Runtime.getRuntime().exec(command, env);
        }
        catch (IOException e) {
            throw new CompilerException("While compiling " + fullFileName, e);
        }
        Thread stdoutThread = new Thread((Runnable)new RunnableStreamListener(new BufferedReader(new InputStreamReader(proc.getInputStream())), System.out), "stdout listener for " + cCtx.getCompiler());
        stdoutThread.start();
        Thread stderrThread = new Thread((Runnable)new RunnableStreamListener(new BufferedReader(new InputStreamReader(proc.getErrorStream())), System.err), "stderr listener for " + cCtx.getCompiler());
        stderrThread.start();
        try {
            n = proc.waitFor();
        }
        catch (InterruptedException e1) {
            throw new CompilerException("While compiling " + fullFileName, e1);
        }
        if (n != 0) {
            throw new CompilerException("Compilation of " + fullFileName + " ended abnormally with code " + n);
        }
    }
}

