/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import org.hsqldb.util.SqlTool;

public class SqlToolSprayer {
    private static final String SYNTAX_MSG = "SYNTAX:  java [-D...] SqlToolSprayer 'SQL;' [urlid1 urlid2...]\nSystem properties you may use [default values]:\n    sqltoolsprayer.period (in ms.) [500]\n    sqltoolsprayer.maxtime (in ms.) [0]\n    sqltoolsprayer.monfile (filepath) [none]\n    sqltoolsprayer.rcfile (filepath) [none.  SqlTool default used.]\n    sqltoolsprayer.propfile (filepath) [none]";

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println(SYNTAX_MSG);
            System.exit(4);
        }
        System.setProperty("sqltool.noexit", "true");
        long l = System.getProperty("sqltoolsprayer.period") == null ? 500 : Integer.parseInt(System.getProperty("sqltoolsprayer.period"));
        long l2 = System.getProperty("sqltoolsprayer.maxtime") == null ? 0 : Integer.parseInt(System.getProperty("sqltoolsprayer.maxtime"));
        String string = System.getProperty("sqltoolsprayer.rcfile");
        String string2 = System.getProperty("sqltoolsprayer.propfile");
        File file = System.getProperty("sqltoolsprayer.monfile") == null ? null : new File(System.getProperty("sqltoolsprayer.monfile"));
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string2 != null) {
            try {
                SqlToolSprayer.getUrlsFromPropFile(string2, arrayList);
            }
            catch (Exception exception) {
                System.err.println("Failed to load property file '" + string2 + "':  " + exception);
                System.exit(3);
            }
        }
        for (int i = 1; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        boolean[] blArray = new boolean[arrayList.size()];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = false;
        }
        String[] stringArray2 = new String[]{"--noinput", "--sql", stringArray[0], "--rcfile", string, null};
        String[] stringArray3 = new String[]{"--noinput", "--sql", stringArray[0], null};
        String[] stringArray4 = string == null ? stringArray3 : stringArray2;
        boolean bl = false;
        long l3 = new Date().getTime();
        while (true) {
            if (file != null && !file.exists()) {
                System.err.println("Required file is gone:  " + file);
                System.exit(2);
            }
            bl = false;
            for (int i = 0; i < blArray.length; ++i) {
                if (blArray[i]) continue;
                stringArray4[stringArray4.length - 1] = (String)arrayList.get(i);
                try {
                    SqlTool.main(stringArray4);
                    blArray[i] = true;
                    System.err.println("Success for instance '" + arrayList.get(i) + "'");
                    continue;
                }
                catch (Exception exception) {
                    bl = true;
                }
            }
            if (!bl || l2 == 0L || new Date().getTime() > l3 + l2) break;
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {}
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i]) continue;
            arrayList2.add((String)arrayList.get(i));
        }
        if (arrayList2.size() > 0) {
            System.err.println("Failed instances:   " + arrayList2);
            System.exit(1);
        }
        System.exit(0);
    }

    private static void getUrlsFromPropFile(String string, ArrayList arrayList) throws Exception {
        Properties properties = new Properties();
        properties.load(new FileInputStream(string));
        int n = -1;
        String string2;
        while ((string2 = properties.getProperty("server.urlid." + ++n)) != null) {
            arrayList.add(string2);
        }
        return;
    }
}

