/*
 *  Jajuk
 *  Copyright (C) 2004 The Jajuk Team
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *  $Revision: 5564 $
 */

package org.jajuk.ui.helpers;

import java.awt.Component;

import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

/**
 * Button render inside a table
 */
public class ButtonRenderer extends JButton implements TableCellRenderer {

  private static final long serialVersionUID = 1L;

  public ButtonRenderer(String sText, Icon icon) {
    super(sText, icon);
  }

  /*
   * (non-Javadoc)
   * 
   * @see
   * javax.swing.table.TableCellRenderer#getTableCellRendererComponent(javax
   * .swing.JTable, java.lang.Object, boolean, boolean, int, int)
   */
  public Component getTableCellRendererComponent(JTable arg0, Object arg1, boolean arg2,
      boolean arg3, int arg4, int arg5) {
    setToolTipText(this.getText());
    return this;
  }

}
