/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime;

import java.util.List;

public class BitSet
implements Cloneable {
    protected static final int BITS = 64;
    protected static final int LOG_BITS = 6;
    protected static final int MOD_MASK = 63;
    protected long[] bits;

    public static BitSet of(int el) {
        BitSet s = new BitSet(el + 1);
        s.add(el);
        return s;
    }

    public static BitSet of(int a, int b) {
        BitSet s = new BitSet(Math.max(a, b) + 1);
        s.add(a);
        s.add(b);
        return s;
    }

    public static BitSet of(int a, int b, int c) {
        BitSet s = new BitSet();
        s.add(a);
        s.add(b);
        s.add(c);
        return s;
    }

    public static BitSet of(int a, int b, int c, int d) {
        BitSet s = new BitSet();
        s.add(a);
        s.add(b);
        s.add(c);
        s.add(d);
        return s;
    }

    public BitSet or(BitSet a) {
        if (a == null) {
            return this;
        }
        BitSet s = (BitSet)this.clone();
        s.orInPlace(a);
        return s;
    }

    public void add(int el) {
        int n = BitSet.wordNumber(el);
        if (n >= this.bits.length) {
            this.growToInclude(el);
        }
        int n2 = n;
        this.bits[n2] = this.bits[n2] | BitSet.bitMask(el);
    }

    public void growToInclude(int bit) {
        int newSize = Math.max(this.bits.length << 1, this.numWordsToHold(bit));
        long[] newbits = new long[newSize];
        System.arraycopy(this.bits, 0, newbits, 0, this.bits.length);
        this.bits = newbits;
    }

    public void orInPlace(BitSet a) {
        if (a == null) {
            return;
        }
        if (a.bits.length > this.bits.length) {
            this.setSize(a.bits.length);
        }
        int min = Math.min(this.bits.length, a.bits.length);
        int i = min - 1;
        while (i >= 0) {
            int n = i;
            this.bits[n] = this.bits[n] | a.bits[i];
            --i;
        }
    }

    private final void setSize(int nwords) {
        long[] newbits = new long[nwords];
        int n = Math.min(nwords, this.bits.length);
        System.arraycopy(this.bits, 0, newbits, 0, n);
        this.bits = newbits;
    }

    private static final long bitMask(int bitNumber) {
        int bitPosition = bitNumber & 0x3F;
        return 1L << bitPosition;
    }

    public Object clone() {
        BitSet s;
        try {
            s = (BitSet)super.clone();
            s.bits = new long[this.bits.length];
            System.arraycopy(this.bits, 0, s.bits, 0, this.bits.length);
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        return s;
    }

    public int size() {
        int deg = 0;
        int i = this.bits.length - 1;
        while (i >= 0) {
            long word = this.bits[i];
            if (word != 0L) {
                int bit = 63;
                while (bit >= 0) {
                    if ((word & 1L << bit) != 0L) {
                        ++deg;
                    }
                    --bit;
                }
            }
            --i;
        }
        return deg;
    }

    public boolean equals(Object other) {
        block8: {
            int i;
            int n;
            BitSet otherSet;
            block7: {
                if (other == null || !(other instanceof BitSet)) {
                    return false;
                }
                otherSet = (BitSet)other;
                n = Math.min(this.bits.length, otherSet.bits.length);
                i = 0;
                while (i < n) {
                    if (this.bits[i] != otherSet.bits[i]) {
                        return false;
                    }
                    ++i;
                }
                if (this.bits.length <= n) break block7;
                i = n + 1;
                while (i < this.bits.length) {
                    if (this.bits[i] != 0L) {
                        return false;
                    }
                    ++i;
                }
                break block8;
            }
            if (otherSet.bits.length <= n) break block8;
            i = n + 1;
            while (i < otherSet.bits.length) {
                if (otherSet.bits[i] != 0L) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean member(int el) {
        if (el < 0) {
            return false;
        }
        int n = BitSet.wordNumber(el);
        if (n >= this.bits.length) {
            return false;
        }
        boolean bl = false;
        if ((this.bits[n] & BitSet.bitMask(el)) != 0L) {
            bl = true;
        }
        return bl;
    }

    public void remove(int el) {
        int n = BitSet.wordNumber(el);
        if (n < this.bits.length) {
            int n2 = n;
            this.bits[n2] = this.bits[n2] & (BitSet.bitMask(el) ^ -1L);
        }
    }

    public boolean isNil() {
        int i = this.bits.length - 1;
        while (i >= 0) {
            if (this.bits[i] != 0L) {
                return false;
            }
            --i;
        }
        return true;
    }

    private final int numWordsToHold(int el) {
        return (el >> 6) + 1;
    }

    public int numBits() {
        return this.bits.length << 6;
    }

    public int lengthInLongWords() {
        return this.bits.length;
    }

    public int[] toArray() {
        int[] elems = new int[this.size()];
        int en = 0;
        int i = 0;
        while (i < this.bits.length << 6) {
            if (this.member(i)) {
                elems[en++] = i;
            }
            ++i;
        }
        return elems;
    }

    public long[] toPackedArray() {
        return this.bits;
    }

    private static final int wordNumber(int bit) {
        return bit >> 6;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String[] tokenNames) {
        StringBuffer buf = new StringBuffer();
        String separator = ",";
        boolean havePrintedAnElement = false;
        buf.append('{');
        int i = 0;
        while (i < this.bits.length << 6) {
            if (this.member(i)) {
                if (i > 0 && havePrintedAnElement) {
                    buf.append(separator);
                }
                if (tokenNames != null) {
                    buf.append(tokenNames[i]);
                } else {
                    buf.append(i);
                }
                havePrintedAnElement = true;
            }
            ++i;
        }
        buf.append('}');
        return buf.toString();
    }

    public BitSet() {
        this(64);
    }

    public BitSet(long[] bits_) {
        this.bits = bits_;
    }

    public BitSet(List items) {
        int i = 0;
        while (i < items.size()) {
            Integer v = (Integer)items.get(i);
            this.add(v);
            ++i;
        }
    }

    public BitSet(int nbits) {
        this.bits = new long[(nbits - 1 >> 6) + 1];
    }
}

