/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2000-2007 Sun Microsystems, Inc. All rights reserved. 
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License ("CDDL") (collectively, the "License").  You may
 * not use this file except in compliance with the License.  You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or mq/legal/LICENSE.txt.  See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at mq/legal/LICENSE.txt.  Sun designates
 * this particular file as subject to the "Classpath" exception as provided by
 * Sun in the GPL Version 2 section of the License file that accompanied this
 * code.  If applicable, add the following below the License Header, with the
 * fields enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or  to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright holder. 
 */

/*
 * @(#)BrokerEventListener.java	1.4 06/29/07
 */ 

package com.sun.messaging.jmq.jmsservice;

/**
 *
 */
public interface BrokerEventListener {

    /**
     *  Notify the BrokerEventListener that a Broker error occurred
     *
     *  @param  error The BrokerErrorEvent that conatins additional information
     *          about the broker erros event.
     */
    public void brokerErrorOccurred(BrokerErrorEvent error);
    
    /**
     *  Notify the BrokerEventListsner that the broker has shutdown.
     *
     *  @param  event The BrokerEvent that contains additional information
     *          about the broker shutdown
     */
    public void brokerShutdown(BrokerEvent event);
    
    /**
     *  Notify the BrokerEventListener that the broker has started
     *  and is responding to jms requests.
     *
     *  @param  event The BrokerEvent that conatins additional information
     *          about the broker start
     */
    public void brokerStarted(BrokerEvent event);

    /**
     *  Notify the BrokerEventLstener that the broker would like to exit.<p>
     *
     *  @param event The BrokerEvent that contains information about the reason
     *               why the broker is requesting to exit. The event Id could
     *               be one of:<p>
     *       <UL>
     *         <LI>REASON_SHUTDOWN</LI>
     *         <LI>REASON_RESTART</LI>
     *         <LI>REASON_FATAL</LI>
     *         <LI>REASON_ERROR</LI>
     *         <LI>REASON_EXCEPTION</LI>
     *         <LI>REASON_STOP</LI>
     *       </UL>
     *  @param thr An optional Throwable
     *
     *  @return true if the broker should clean up and exit and false
     *         if the request to exit was denied (if the request to
     *         shutdown after a fatal error is denied, the broker may not
     *         respond correctly).
     */
    public boolean exitRequested(BrokerEvent event, Throwable thr);

}
