/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2000-2007 Sun Microsystems, Inc. All rights reserved. 
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License ("CDDL") (collectively, the "License").  You may
 * not use this file except in compliance with the License.  You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or mq/legal/LICENSE.txt.  See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at mq/legal/LICENSE.txt.  Sun designates
 * this particular file as subject to the "Classpath" exception as provided by
 * Sun in the GPL Version 2 section of the License file that accompanied this
 * code.  If applicable, add the following below the License Header, with the
 * fields enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or  to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright holder. 
 */

/*
 * @(#)TCPConnectionHandler.java	1.23 06/27/07
 */ 

package com.sun.messaging.jmq.jmsclient.protocol.tcp;

import javax.jms.*;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.ConnectionConfiguration;
import com.sun.messaging.jmq.jmsclient.*;

import java.net.*;
import java.io.*;


/**
 * This class is the default protocol handler for the iMQ JMS client
 * implementation.  It uses TCP protocol to communicate with the Broker.
 */
public class TCPConnectionHandler implements ConnectionHandler {

    private static int connectionCount = 0;
    private int counter = 0;

    private Socket socket = null;
    //private static int soLingerTime = 5;

    private String host = null;

    private int baseport = 0;
    private int directport = 0;
    private int port = 0;

    /**
     * Constructor.  Called by TCPStreamHandler.
     * This creates a socket connection to the broker.
     */
    TCPConnectionHandler (Object conn) throws JMSException {
        ConnectionImpl connection = (ConnectionImpl) conn;
        directport = 0;

        // First, gather the configuration attributes.
        host = connection.getProperty(
            ConnectionConfiguration.imqBrokerHostName);
        baseport = Integer.parseInt(connection.getProperty(
            ConnectionConfiguration.imqBrokerHostPort));
        directport = Integer.parseInt(connection.getProperty(
            ConnectionConfiguration.imqBrokerServicePort));
        String namedservice = connection.getProperty(
            ConnectionConfiguration.imqBrokerServiceName);

        // Resolve the service port if necessary.
        if (directport == 0) {
            PortMapperClient pmc = new PortMapperClient(connection);
            if (namedservice != null && !("".equals(namedservice))) {
                port = pmc.getPortForService("tcp", namedservice);
            } else {
                port = pmc.getPortForProtocol("tcp");
            }
        } else {
            port = directport;
        }

        ConnectionImpl.checkHostPort (host, port);

        // Create the connection
        try {
            connection.setLastContactedBrokerAddress( getBrokerAddress() );
            this.socket = makeSocket(host, port);
            counter = ++connectionCount;
        } catch ( Exception e ) {
            connection.getExceptionHandler().handleConnectException (
                e, host, port);
        }
    }

    /**
     * Constructor.  Called by TCPStreamHandler.
     * This creates a socket connection to the broker.
     */
    TCPConnectionHandler (MQAddress addr, ConnectionImpl conn)
        throws JMSException {
        ConnectionImpl connection = (ConnectionImpl) conn;
        port = 0;

        // First, gather the configuration attributes.
        host = addr.getHostName();
        directport = 0;
        if (addr.isServicePortFinal())
            directport = addr.getPort();
        String namedservice = addr.getServiceName();

        // Resolve the service port if necessary.
        if (directport == 0) {
            PortMapperClient pmc = new PortMapperClient(addr, connection);
            baseport = pmc.getHostPort();
            if (namedservice != null && !("".equals(namedservice))) {
                port = pmc.getPortForService("tcp", namedservice);
            } else {
                port = pmc.getPortForProtocol("tcp");
            }

        } else {
            port = directport;
        }

        conn.setLastContactedBrokerAddress( getBrokerAddress() );

        ConnectionImpl.checkHostPort (host, port);

        // Create the connection
        try {
            this.socket = makeSocket(host, port);
            counter = ++connectionCount;
        } catch ( Exception e ) {
            connection.getExceptionHandler().handleConnectException (
                e, host, port);
        }
    }

    private Socket makeSocket(String host, int port) throws Exception {
        if (Debug.debug) {
            Debug.println("in TCPConnectionHandler.makeSocket()");
        }

        //tcp no delay flag
        boolean tcpNoDelay = true;
        String prop = System.getProperty("imqTcpNoDelay", "true");
        if ( prop.equals("false") ) {
            tcpNoDelay = false;
        }

        Socket socket = new Socket(host, port);
        socket.setTcpNoDelay( tcpNoDelay );

        return socket;
    }

    /*
     * Get socket input stream.
     */
    public InputStream
    getInputStream() throws IOException {
        return socket.getInputStream();
    }

     /*
     * Get socket output stream.
     */
    public OutputStream
    getOutputStream() throws IOException {
        return socket.getOutputStream();
    }

     /*
     * Get socket local port for the current connection.
     */
    public int
    getLocalPort() throws IOException {
        return socket.getLocalPort();
    }

     /*
     * close socket.
     */
    public void
    close() throws IOException {
        socket.close();
    }

    public String getBrokerHostName() {
        return this.host;
    }

    public String getBrokerAddress() {

        if (directport == 0) {
            return host + ":" + baseport + "(" + port + ")";
        } else {
            return host + ":" + directport;
        }
        //return host + ":" port;
    }


    public String toString() {
        String info = null;
        try {
        info =  "TCPConnectionHandler: " + counter + "-" + getLocalPort();
        } catch (Exception e) {
            Debug.printStackTrace(e);
        }

        return info;
    }

}
