/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2000-2007 Sun Microsystems, Inc. All rights reserved. 
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License ("CDDL") (collectively, the "License").  You may
 * not use this file except in compliance with the License.  You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or mq/legal/LICENSE.txt.  See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at mq/legal/LICENSE.txt.  Sun designates
 * this particular file as subject to the "Classpath" exception as provided by
 * Sun in the GPL Version 2 section of the License file that accompanied this
 * code.  If applicable, add the following below the License Header, with the
 * fields enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or  to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright holder. 
 */

/*
 * @(#)DialogEvent.java	1.12 06/28/07
 */ 

package com.sun.messaging.jmq.admin.apps.console.event;

import java.util.EventObject;

/**
 * Events related to showing any kind of dialog in the admin
 * console application.
 * <P>
 * The event type field is not used in this class. Instead,
 * a dialog type field is used instead. This is because the
 * type of dialog events that are needed for now is an
 * event that says: Please show this dialog.
 *
 * <P>
 * If the need arises for an event that indicates that
 * a dialog needs to be hidden, maybe distinct dialog event types
 * need to be introduced or a flag that indicates whether
 * dialog needs to be shown/hidden.
 */
public class DialogEvent extends AdminEvent {
    /*
     * Dialog type
     */
    public final static int	ADD_DIALOG 		= 0;
    public final static int	DELETE_DIALOG 		= 1;
    public final static int	PURGE_DIALOG 		= 2;
    public final static int	PROPS_DIALOG 		= 3;
    public final static int	SHUTDOWN_DIALOG 	= 4;
    public final static int	RESTART_DIALOG 		= 5;
    public final static int	PAUSE_DIALOG 		= 6;
    public final static int	RESUME_DIALOG 		= 7;
    public final static int	CONNECT_DIALOG 		= 8;
    public final static int	DISCONNECT_DIALOG	= 9;
    public final static int	HELP_DIALOG		= 10;

    private int		dialogType;

    /**
     * Creates an instance of DialogEvent
     * @param source the object where the event originated
     */
    public DialogEvent(Object source) {
	super(source);
    }

    /*
     * Sets the dialog type. This is the dialog
     * that needs to be shown.
     */
    public void setDialogType(int dialogType)  {
	this.dialogType = dialogType;
    }
    /*
     * Returns the dialog type. This is the dialog
     * that needs to be shown.
     */
    public int getDialogType()  {
	return (dialogType);
    }
}
