/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.net.ProtocolStreams;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.ConvertPacket;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.NotificationInfo;
import com.sun.messaging.jmq.jmsserver.service.imq.Operation;
import com.sun.messaging.jmq.jmsserver.service.imq.OperationRunnable;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.MetricManager;
import com.sun.messaging.jmq.jmsserver.util.memory.MemoryCallback;
import com.sun.messaging.jmq.net.IPAddress;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.NFLPriorityFifoSet;
import com.sun.messaging.jmq.util.lists.Reason;
import com.sun.messaging.jmq.util.timer.MQTimer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TimerTask;
import java.util.Vector;

public class IMQIPConnection
extends IMQConnection
implements Operation,
MemoryCallback {
    public static boolean expectPingReply = false;
    public static final int closeInterval = Globals.getConfig().getIntProperty("imq.ping.close.interval", 5);
    public static final boolean enablePingReply = Globals.getConfig().getBooleanProperty("imq.ping.reply.enable", true);
    private static byte[] ipAddress = null;
    private int ctrlPktsToConsumer = 0;
    private int[] pktsIn = new int[80];
    private int[] pktsOut = new int[80];
    private int pauseFlowCnt = 0;
    private int resumeFlowCnt = 0;
    boolean STREAMS = true;
    boolean BLOCKING = false;
    Set tmpDestinations = Collections.synchronizedSet(new HashSet());
    private Object timerLock = new Object();
    private static final int NO_VERSION = 0;
    public static final int CURVERSION = 301;
    public int packetVersion = 0;
    ConvertPacket convertPkt = null;
    public static final int DEFAULT_INTERVAL = 180;
    public static final String CLIENT_ID = "client id";
    public static final String TRANSACTION_LIST = "transaction";
    public static final String TRANSACTION_IDMAP = "tidmap";
    public static final String TRANSACTION_CACHE = "txncache";
    public static final String USER_AGENT = "useragent";
    private static boolean DEBUG;
    private static boolean DUMP_PACKET;
    private static boolean OUT_DUMP_PACKET;
    private static boolean IN_DUMP_PACKET;
    public boolean METRICS_ON = MetricManager.isEnabled();
    private static boolean OVERRIDE_CTRL_PACKET;
    private static boolean OVERRIDE_READ_PACKET;
    private static boolean OVERRIDE_FILL_PACKET;
    private static boolean O_CTRL_USE_DIRECT;
    private static boolean O_READ_USE_DIRECT;
    private static boolean O_FILL_USE_DIRECT;
    PacketRouter router = null;
    byte[] empty = new byte[]{0};
    Object ctrlEL = null;
    private StateWatcher stateWatcher = null;
    private int interval = 180;
    protected ProtocolStreams ps = null;
    protected SocketChannel channel;
    protected InputStream is = null;
    protected OutputStream os = null;
    protected boolean critical = false;
    private boolean flush = false;
    private boolean flushCtrl = false;
    private Object flushLock = new Object();
    private Object flushCtrlLock = new Object();
    private boolean flushCritical = false;
    private boolean lockCritical = false;
    private OperationRunnable read_assigned;
    private OperationRunnable write_assigned;
    NotificationInfo ninfo = null;
    Object releaseWaitLock = new Object();
    String remoteHostString = null;
    String remoteConString = null;
    String localsvcstring = null;
    int destroyRecurse = 0;
    private NFLPriorityFifoSet control = null;
    boolean hasCtrl = true;
    Packet readpkt = null;
    private boolean inReadProcess = false;
    private Packet ctrlpkt = null;
    private Packet waitingWritePkt = null;
    private boolean inCtrlWrite = false;
    private boolean inJMSWrite = false;
    boolean inWriteProcess = false;

    public static boolean getDumpPacket() {
        return DUMP_PACKET;
    }

    public static boolean getDumpInPacket() {
        return IN_DUMP_PACKET;
    }

    public static boolean getDumpOutPacket() {
        return OUT_DUMP_PACKET;
    }

    public static void dumpPacket(boolean bl) {
        DUMP_PACKET = bl;
    }

    public static void dumpInPacket(boolean bl) {
        IN_DUMP_PACKET = bl;
    }

    public static void dumpOutPacket(boolean bl) {
        OUT_DUMP_PACKET = bl;
    }

    public IMQIPConnection(Service service, ProtocolStreams protocolStreams, PacketRouter packetRouter) throws IOException, BrokerException {
        super(service);
        this.ps = protocolStreams;
        InetAddress inetAddress = protocolStreams.getRemoteAddress();
        if (inetAddress != null) {
            this.setRemoteIP(inetAddress.getAddress());
        }
        this.STREAMS = protocolStreams.getChannel() == null;
        this.BLOCKING = protocolStreams.getBlocking();
        this.router = packetRouter;
        this.accessController = AccessController.getInstance(service.getName(), service.getServiceType());
        this.control = new NFLPriorityFifoSet();
        this.ctrlEL = this.control.addEventListener(this, EventType.EMPTY, null);
        this.channel = (SocketChannel)protocolStreams.getChannel();
        this.is = protocolStreams.getInputStream();
        this.os = protocolStreams.getOutputStream();
        this.setConnectionState(0);
        this.waitingWritePkt = new Packet(OVERRIDE_FILL_PACKET ? O_FILL_USE_DIRECT : !this.STREAMS);
        if (!this.isAdminConnection() && Globals.getMemManager() != null) {
            Globals.getMemManager().registerMemoryCallback(this);
        }
    }

    public void dumpState() {
        super.dumpState();
        this.logger.log(8, "\tcontrol = " + this.control.size());
        this.logger.log(8, "\tread_assigned = " + this.read_assigned);
        this.logger.log(8, "\twrite_assigned = " + this.write_assigned);
        if (this.ninfo != null) {
            this.ninfo.dumpState();
        }
    }

    public int getLocalPort() {
        if (this.ps == null) {
            return 0;
        }
        return this.ps.getLocalPort();
    }

    public synchronized Hashtable getDebugState() {
        Hashtable hashtable = super.getDebugState();
        hashtable.put("pkts[TOTAL](in,out) ", "(" + this.msgsIn + "," + (this.ctrlPktsToConsumer + this.msgsToConsumer) + ")");
        for (int i = 0; i < this.pktsIn.length; ++i) {
            if (this.pktsIn[i] == 0 && this.pktsOut[i] == 0) continue;
            hashtable.put("pkts[" + PacketType.getString(i) + "] (in,out)", "(" + this.pktsIn[i] + "," + this.pktsOut[i] + ")");
        }
        hashtable.put("ctrlPktsToConsumer", String.valueOf(this.ctrlPktsToConsumer));
        hashtable.put("critical", String.valueOf(this.critical));
        hashtable.put("controlSize", String.valueOf(this.control.size()));
        if (this.control.size() > 0) {
            Vector<String> vector = new Vector<String>();
            for (Packet packet : this.control) {
                vector.add(packet.toString());
            }
            hashtable.put("control", vector);
        }
        hashtable.put("transport", this.ps.getDebugState());
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDebugMessages(boolean bl) {
        Vector<String> vector = new Vector<String>();
        NFLPriorityFifoSet nFLPriorityFifoSet = this.control;
        synchronized (nFLPriorityFifoSet) {
            for (PacketReference packetReference : this.control) {
                vector.add(bl ? packetReference.getPacket().dumpPacketString() : packetReference.getPacket().toString());
            }
        }
        return vector;
    }

    public ConnectionInfo getConnectionInfo() {
        this.coninfo = super.getConnectionInfo();
        this.coninfo.remPort = this.ps == null ? 0 : this.ps.getRemotePort();
        return this.coninfo;
    }

    public void countInPacket(Packet packet) {
        if (packet == null) {
            return;
        }
        if (packet.getPacketType() <= 6 && packet.getPacketType() >= 1) {
            this.counters.updateIn(1L, packet.getPacketSize(), 1L, packet.getPacketSize());
        } else {
            this.counters.updateIn(0L, 0L, 1L, packet.getPacketSize());
        }
    }

    public void countOutPacket(Packet packet) {
        if (packet == null) {
            return;
        }
        if (packet.getPacketType() <= 6 && packet.getPacketType() >= 1) {
            this.counters.updateOut(1L, packet.getPacketSize(), 1L, packet.getPacketSize());
        } else {
            this.counters.updateOut(0L, 0L, 1L, packet.getPacketSize());
        }
    }

    public boolean useDirectBuffers() {
        return OVERRIDE_CTRL_PACKET ? O_CTRL_USE_DIRECT : !this.STREAMS;
    }

    public synchronized AbstractSelectableChannel getChannel() {
        if (this.ps == null) {
            return null;
        }
        return this.ps.getChannel();
    }

    public boolean canKill() {
        return !this.critical;
    }

    public void setCritical(boolean bl) {
        this.critical = bl;
    }

    public boolean waitUntilDestroyed(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (this.isValid() && System.currentTimeMillis() < l2) {
            this.waitForWork(l);
        }
        return this.isValid();
    }

    public synchronized void notifyRelease(OperationRunnable operationRunnable, int n) {
        int n2 = 0;
        if ((n & 4) > 0 && operationRunnable == this.write_assigned) {
            n2 |= 4;
            this.write_assigned = null;
        }
        if ((n & 1) > 0 && operationRunnable == this.read_assigned) {
            n2 |= 1;
            this.read_assigned = null;
        }
        if (this.ninfo != null && n2 != 0) {
            this.ninfo.released(this, n2);
        }
        this.notifyAll();
    }

    public synchronized void waitForRelease(long l) {
        long l2 = 5000L;
        while (this.read_assigned != null || this.write_assigned != null) {
            if (l <= 0L) {
                Globals.getLogger().log(16, "Timeout in waiting for runnable threads release in " + this);
                return;
            }
            Globals.getLogger().log(8, "Waiting for runnable threads release in " + this);
            if (l < l2) {
                l2 = l;
            }
            try {
                this.wait(l2);
            }
            catch (InterruptedException interruptedException) {
                Globals.getLogger().log(16, "Interrupted in waiting for runnable threads release in " + this);
                return;
            }
            l -= l2;
        }
    }

    public synchronized void clearAssigned() {
        this.read_assigned = null;
        this.write_assigned = null;
    }

    public synchronized OperationRunnable getReadRunnable() {
        return this.read_assigned;
    }

    public synchronized OperationRunnable getWriteRunnable() {
        return this.write_assigned;
    }

    public synchronized void threadAssigned(OperationRunnable operationRunnable, int n) throws IllegalAccessException {
        int n2 = 0;
        if ((n & 4) > 0) {
            if (this.write_assigned != null) {
                n2 |= 4;
            }
            this.write_assigned = operationRunnable;
        }
        if ((n & 1) > 0) {
            if (this.read_assigned != null) {
                n2 |= 1;
            }
            this.read_assigned = operationRunnable;
        }
        if (this.ninfo != null) {
            if (n2 != 0) {
                this.ninfo.released(this, n2);
            }
            this.ninfo.assigned(this, n);
        }
    }

    public void attach(NotificationInfo notificationInfo) {
        this.ninfo = notificationInfo;
    }

    public NotificationInfo attachment() {
        return this.ninfo;
    }

    private String getKeyString(int n) {
        String string = "";
        if ((n & 4) > 0) {
            string = string + " WRITE ";
        }
        if ((n & 1) > 0) {
            string = string + " READ ";
        }
        return string;
    }

    public boolean process(int n, boolean bl) throws IOException {
        boolean bl2 = false;
        boolean bl3 = true;
        int n2 = 0;
        int n3 = 0;
        try {
            while (bl3) {
                bl3 = false;
                if ((n & 4) > 0) {
                    while (this.writeData(bl) == 0) {
                        bl3 = true;
                        ++n3;
                    }
                }
                if ((n & 1) > 0) {
                    int n4 = this.readData();
                    switch (n4) {
                        case 0: {
                            bl3 = true;
                        }
                    }
                    ++n2;
                }
                bl2 |= bl3;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.logger.log(32, "B3143", (Object)this, (Throwable)outOfMemoryError);
            int n5 = 0;
            boolean bl4 = true;
            while (true) {
                try {
                    this.logger.log(32, "Received out of memory error trying to shutdown");
                    this.closeConnection(bl4, 4, outOfMemoryError.toString());
                    bl4 = false;
                }
                catch (OutOfMemoryError outOfMemoryError2) {
                    this.logger.log(4, "Connection could not be cleanly closed, trying again on " + this, outOfMemoryError);
                    if (++n5 < 2) continue;
                    throw outOfMemoryError2;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Throwable throwable) {
            this.logger.logStack(32, "Internal Error: Received unexpected exception processing connection  closing connection", throwable);
            this.closeConnection(true, 4, throwable.toString());
        }
        return !bl2;
    }

    public boolean equals(Object object) {
        if (object instanceof ConnectionUID) {
            return object.equals(this.getConnectionUID());
        }
        if (object instanceof Connection) {
            return ((Connection)object).getConnectionUID().equals(this.getConnectionUID());
        }
        return false;
    }

    public String toString() {
        return "IMQConn[" + IMQIPConnection.getConnectionStateString(this.state) + "," + this.getRemoteConnectionString() + "," + this.localsvcstring + "]";
    }

    public String toDebugString() {
        return super.toString() + " state: " + this.state;
    }

    public String remoteHostString() {
        if (this.remoteHostString == null) {
            try {
                InetAddress inetAddress = InetAddress.getByAddress(this.getRemoteIP());
                this.remoteHostString = inetAddress.getHostName();
            }
            catch (Exception exception) {
                this.remoteHostString = IPAddress.rawIPToString(this.getRemoteIP(), true, true);
            }
        }
        return this.remoteHostString;
    }

    public String getRemoteConnectionString() {
        Object object;
        String string;
        String string2;
        boolean bl;
        block6: {
            if (this.remoteConString != null) {
                return this.remoteConString;
            }
            bl = false;
            string2 = "???";
            string = "???";
            if (this.state >= 4) {
                try {
                    object = this.getAuthenticatedName();
                    if (object != null) {
                        string = object.getName();
                        bl = true;
                    }
                }
                catch (BrokerException brokerException) {
                    if (!DEBUG) break block6;
                    this.logger.log(4, "Exception getting authentication name " + this.conId, brokerException);
                }
            }
        }
        string2 = Integer.toString(this.ps == null ? 0 : this.ps.getRemotePort());
        object = string + "@" + IPAddress.rawIPToString(this.getRemoteIP(), true, true) + ":" + string2;
        if (bl) {
            this.remoteConString = object;
        }
        return object;
    }

    protected String localServiceString() {
        if (this.localsvcstring != null) {
            return this.localsvcstring;
        }
        String string = "???";
        string = Integer.toString(this.ps == null ? 0 : this.ps.getLocalPort());
        this.localsvcstring = this.service.getName() + ":" + string;
        return this.localsvcstring;
    }

    public synchronized void closeConnection(boolean bl, int n, String string) {
        if (this.state >= 6) {
            this.logger.log(4, "Requested close of already closed connection:" + this);
            return;
        }
        this.state = 6;
        this.stopConnection();
        if (Globals.getMemManager() != null) {
            Globals.getMemManager().removeMemoryCallback(this);
        }
        if (bl) {
            this.sayGoodbye(false, n, string);
            this.flushControl(1000L);
        }
        this.control.removeEventListener(this.ctrlEL);
        this.cleanup(n == 1);
        if (this.ninfo != null) {
            this.ninfo.destroy(string);
        }
        try {
            if (this.ps != null) {
                this.ps.close();
            }
            this.ps = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n == 1) {
            this.cleanupConnection();
        } else {
            this.cleanup(false);
        }
    }

    protected void cleanupControlPackets(boolean bl) {
        while (!this.control.isEmpty()) {
            Packet packet = (Packet)this.control.removeNext();
            if (packet == null) continue;
            packet.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyConnection(boolean bl, int n, String string) {
        int n2 = 0;
        boolean bl2 = false;
        try {
            Object object = this;
            synchronized (object) {
                block19: {
                    n2 = this.state;
                    if (this.state < 7) break block19;
                    return;
                }
                if (this.state < 6) {
                    this.closeConnection(bl, n, string);
                }
                this.setConnectionState(7);
            }
            Globals.getConnectionManager().removeConnection(this.getConnectionUID(), bl, n, string);
            if (this.accessController.isAuthenticated()) {
                this.accessController.logout();
            }
            if ((object = Globals.getMetricManager()) != null) {
                ((MetricManager)object).depositTotals(this.service.getName(), this.counters);
            }
            this.counters.reset();
            Object object2 = this.timerLock;
            synchronized (object2) {
                if (this.stateWatcher != null) {
                    try {
                        this.stateWatcher.cancel();
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.logger.log(4, "Error destroying  connection " + this + " to state " + this.state, illegalStateException);
                    }
                    this.stateWatcher = null;
                }
            }
            this.logConnectionInfo(true, string);
            this.setConnectionState(8);
            bl2 = true;
            this.wakeup();
        }
        finally {
            if (!(bl2 || n == 1 || Globals.getMemManager() != null && Globals.getMemManager().getCurrentLevel() <= 0)) {
                this.state = n2;
                if (this.destroyRecurse < 2) {
                    ++this.destroyRecurse;
                    this.destroyConnection(bl, n, string);
                }
            }
            Globals.getClusterBroadcast().connectionClosed(this.getConnectionUID(), this.isAdminConnection());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setConnectionState(int n) {
        Object object = this.timerLock;
        synchronized (object) {
            this.state = n;
            if (this.state >= 6) {
                if (this.stateWatcher != null) {
                    try {
                        this.stateWatcher.cancel();
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.logger.log(4, "Error setting state on  connection " + this + " to state " + n, illegalStateException);
                    }
                    this.stateWatcher = null;
                }
                this.wakeup();
                return false;
            }
            if (n == 0) {
                this.interval = Globals.getConfig().getIntProperty("imq.authentication.client.response.timeout", 180);
                MQTimer mQTimer = Globals.getTimer(true);
                this.stateWatcher = new StateWatcher(1, this);
                try {
                    mQTimer.schedule((TimerTask)this.stateWatcher, this.interval * 1000);
                }
                catch (IllegalStateException illegalStateException) {
                    this.logger.log(4, "InternalError: timer canceled ", illegalStateException);
                }
            } else if (n == 1 || n == 2 || n == 3) {
                if (this.stateWatcher != null) {
                    try {
                        this.stateWatcher.cancel();
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.logger.log(4, "Error setting state on  connection " + this + " to state " + n, illegalStateException);
                    }
                    this.stateWatcher = null;
                }
                if (n == 1) {
                    return true;
                }
                if (n == 3) {
                    return true;
                }
                MQTimer mQTimer = Globals.getTimer(true);
                this.stateWatcher = new StateWatcher(3, this);
                try {
                    mQTimer.schedule((TimerTask)this.stateWatcher, this.interval * 1000);
                }
                catch (IllegalStateException illegalStateException) {
                    this.logger.log(4, "InternalError: timer canceled ", illegalStateException);
                }
            } else if (n >= 4 || n == -1) {
                if (this.stateWatcher != null) {
                    try {
                        this.stateWatcher.cancel();
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.logger.log(4, "Error setting state on  connection " + this + " to state " + n, illegalStateException);
                    }
                    this.stateWatcher = null;
                }
                if (n == 4) {
                    this.logConnectionInfo(false);
                }
            }
        }
        return true;
    }

    public void logConnectionInfo(boolean bl) {
        this.logConnectionInfo(bl, "Unknown");
    }

    public void logConnectionInfo(boolean bl, String string) {
        Object[] objectArray = new String[]{this.getRemoteConnectionString(), this.localServiceString(), Integer.toString(Globals.getConnectionManager().size()), string, String.valueOf(this.control.size()), Integer.toString(this.service.size())};
        if (!bl) {
            this.logger.log(8, "B1065", objectArray);
        } else {
            this.logger.log(8, "B1066", objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendControlMessage(Packet packet) {
        if (!this.isValid() && packet.getPacketType() != 28) {
            this.logger.log(8, "Internal Warning: message " + packet + "queued on destroyed connection " + this);
        }
        this.control.add(packet);
        NFLPriorityFifoSet nFLPriorityFifoSet = this.control;
        synchronized (nFLPriorityFifoSet) {
            this.hasCtrl = !this.control.isEmpty();
        }
    }

    protected void sendControlMessage(Packet packet, boolean bl) {
        if (DEBUG) {
            this.logger.log(1, "IMQIPConnection[ {0} ] queueing Admin packet {1}", (Object)this.toString(), packet.toString());
        }
        if (!this.isValid()) {
            return;
        }
        assert (!bl);
        this.sendControlMessage(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushControl(long l) {
        if (this.read_assigned == this.write_assigned && this.read_assigned != null) {
            this.localFlushCtrl();
            return;
        }
        Object object = this.flushCtrlLock;
        synchronized (object) {
            if (DEBUG) {
                this.logger.log(4, "Flushing Control Messages with timeout of " + l);
            }
            if (this.ctrlpkt == null && this.control.isEmpty() && !this.flushCritical) {
                return;
            }
            if (!this.isValid()) {
                return;
            }
            long l2 = System.currentTimeMillis();
            this.flushCtrl = true;
            if (l < 0L) {
                return;
            }
            while (this.flushCtrl && this.isValid()) {
                try {
                    if (l != 0L) {
                        this.flushCtrlLock.wait(l);
                    } else {
                        this.flushCtrlLock.wait(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.flushCtrl || l <= 0L || System.currentTimeMillis() < l2 + l) continue;
            }
            this.flushCtrl = false;
            if (DEBUG) {
                if (this.flush) {
                    this.logger.log(4, "Control Flush did not complete in timeout of " + l);
                } else {
                    this.logger.log(4, "Contrl Flush completed");
                }
            }
        }
    }

    private void localFlushCtrl() {
        this.flushCtrl = true;
        try {
            while (this.writeData(false) != 1) {
            }
        }
        catch (Exception exception) {
            this.logger.log(4, "error in flush " + this, exception);
        }
        this.flushCtrl = false;
    }

    private void localFlush() {
        this.flush = true;
        try {
            while (this.writeData(false) != 1) {
            }
        }
        catch (Exception exception) {
            this.logger.log(4, "error in flush " + this, exception);
        }
        this.flush = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(long l) {
        if (this.read_assigned == this.write_assigned && this.read_assigned != null) {
            this.localFlush();
            return;
        }
        if (!this.inCtrlWrite && this.control.isEmpty() && !this.inJMSWrite && this.hasBusySessions() && !this.flushCritical && !this.lockCritical) {
            return;
        }
        Object object = this.flushLock;
        synchronized (object) {
            if (DEBUG) {
                this.logger.log(4, "Flushing Messages with timeout of " + l);
            }
            if (!this.isValid()) {
                return;
            }
            if (!this.inCtrlWrite && this.control.isEmpty() && !this.inJMSWrite && this.hasBusySessions() && !this.flushCritical && !this.lockCritical) {
                return;
            }
            long l2 = System.currentTimeMillis();
            this.flush = true;
            while (this.flush && this.isValid()) {
                try {
                    if (l != 0L) {
                        this.flushLock.wait(l);
                    } else {
                        this.flushLock.wait(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.flush || l <= 0L || System.currentTimeMillis() < l2 + l) continue;
            }
            if (DEBUG) {
                if (this.flush) {
                    this.logger.log(4, "Flush did not complete in timeout of " + l);
                } else {
                    this.logger.log(4, "Flush completed");
                }
            }
        }
    }

    void dumpConnectionInfo() {
        if (this.ninfo != null) {
            this.logger.log(8, "Connection Information [" + this + "]" + this.ninfo.getStateInfo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkConnection(int n) {
        Object[] objectArray = this.timerLock;
        synchronized (this.timerLock) {
            try {
                this.stateWatcher.cancel();
            }
            catch (IllegalStateException illegalStateException) {
                this.logger.log(4, "Error destroying  connection " + this + " to state " + n, illegalStateException);
            }
            this.stateWatcher = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            objectArray = new String[]{this.toString(), IMQIPConnection.getConnectionStateString(this.state), IMQIPConnection.getConnectionStateString(n), String.valueOf(this.interval)};
            IMQIPConnection iMQIPConnection = this;
            synchronized (iMQIPConnection) {
                if (this.state >= n) {
                    return;
                }
                if (this.state >= 6 || this.state == -1) {
                    return;
                }
                this.logger.log(16, Globals.getBrokerResources().getKString("B2051", objectArray));
            }
            if (DEBUG) {
                this.dumpConnectionInfo();
            }
            this.destroyConnection(false, 4, Globals.getBrokerResources().getKString("B2051", objectArray));
            return;
        }
    }

    /*
     * Exception decompiling
     */
    public int readData() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int writeData(boolean bl) throws IOException {
        block167: {
            NFLPriorityFifoSet nFLPriorityFifoSet;
            assert (!this.inWriteProcess);
            if (this.hasCtrl) {
                nFLPriorityFifoSet = this.control;
                // MONITORENTER : nFLPriorityFifoSet
                this.hasCtrl = !this.control.isEmpty();
                // MONITOREXIT : nFLPriorityFifoSet
            }
            try {
                Object object;
                int n;
                try {
                    this.inWriteProcess = true;
                    if (DEBUG) {
                        this.logger.log(4, "Writing IMQIPConnection {0} ", this.toString());
                    }
                    while (bl && !this.isBusy() && this.isValid()) {
                        this.waitForWork(0L);
                    }
                    if (!this.isValid()) {
                        throw new IOException(Globals.getBrokerResources().getKString("B4117", "destroyed Connection"));
                    }
                    if (!this.isBusy()) {
                        int n2 = 1;
                        Object var8_15 = null;
                        this.inWriteProcess = false;
                        Object object2 = this.flushCtrlLock;
                        // MONITORENTER : object2
                        if (this.flushCtrl && (this.ctrlpkt == null && this.control.isEmpty() || !this.isValid())) {
                            if (DEBUG) {
                                this.logger.log(4, "Done flushing control messages on " + this);
                            }
                            this.flushCtrl = false;
                            this.flushCtrlLock.notifyAll();
                            this.os.flush();
                        }
                        // MONITOREXIT : object2
                        if (this.flush) {
                            object2 = this.flushLock;
                            // MONITORENTER : object2
                            if (!this.isBusy() || !this.isValid()) {
                                if (DEBUG) {
                                    this.logger.log(4, "Done flushing control messages on " + this);
                                }
                                this.flush = false;
                                this.flushLock.notifyAll();
                                this.os.flush();
                            }
                            // MONITOREXIT : object2
                        }
                        if (this.isValid()) return n2;
                        object2 = this;
                        // MONITORENTER : object2
                        if (this.waitingWritePkt != null) {
                            this.waitingWritePkt.destroy();
                        }
                        this.waitingWritePkt = null;
                        // MONITOREXIT : object2
                        return n2;
                    }
                    this.flushCritical = true;
                    if (!this.inCtrlWrite && !this.inJMSWrite) {
                        if (!this.control.isEmpty()) {
                            this.ctrlpkt = (Packet)this.control.removeNext();
                            if (this.ctrlpkt != null) {
                                this.inCtrlWrite = true;
                            }
                        } else {
                            nFLPriorityFifoSet = this.control;
                            // MONITORENTER : nFLPriorityFifoSet
                            this.hasCtrl = !this.control.isEmpty();
                            // MONITOREXIT : nFLPriorityFifoSet
                        }
                    }
                    if (this.ctrlpkt != null) {
                        if (this.ctrlpkt.getPacketType() > 6) {
                            this.ctrlpkt.setIP(ipAddress);
                            this.ctrlpkt.setPort(this.getLocalPort());
                        }
                        if (this.convertPkt != null) {
                            this.convertPkt.handleWritePacket(this.ctrlpkt);
                        }
                        if (DEBUG || DUMP_PACKET || OUT_DUMP_PACKET) {
                            int n3 = DUMP_PACKET || OUT_DUMP_PACKET ? 8 : 1;
                            this.logger.log(n3, "\n------------------------------\nSending Control Packet -[block = " + this.BLOCKING + ",nio = " + !this.STREAMS + "]   Dumping" + "\n------------------------------" + "\n" + this.ctrlpkt.dumpPacketString("<<<<****") + "\n------------------------------");
                        }
                        if (this.STREAMS) {
                            this.ctrlpkt.writePacket(this.os);
                            this.inCtrlWrite = false;
                        } else {
                            boolean bl2 = this.inCtrlWrite = !this.ctrlpkt.writePacket(this.channel, this.BLOCKING);
                        }
                        if (!this.inCtrlWrite) {
                            if (this.ctrlpkt.getPacketType() < 80) {
                                int n4 = this.ctrlpkt.getPacketType();
                                this.pktsOut[n4] = this.pktsOut[n4] + 1;
                            }
                            ++this.ctrlPktsToConsumer;
                            if (DEBUG || DUMP_PACKET || OUT_DUMP_PACKET) {
                                this.logger.log(8, "Finished writing packet [" + this.ctrlpkt + "]");
                            }
                            if (Globals.getConnectionManager().PING_ENABLED) {
                                this.updateAccessTime(false);
                            }
                            if (this.METRICS_ON) {
                                this.countOutPacket(this.ctrlpkt);
                            }
                            assert (this.ctrlpkt != null);
                            this.ctrlpkt.destroy();
                            this.ctrlpkt = null;
                        }
                        this.flushCritical = false;
                        Object object3 = this.stateLock;
                        // MONITORENTER : object3
                        this.checkState();
                        // MONITOREXIT : object3
                        if (this.inCtrlWrite) {
                            int n5 = 2;
                            Object var8_16 = null;
                            this.inWriteProcess = false;
                            Object object4 = this.flushCtrlLock;
                            // MONITORENTER : object4
                            if (this.flushCtrl && (this.ctrlpkt == null && this.control.isEmpty() || !this.isValid())) {
                                if (DEBUG) {
                                    this.logger.log(4, "Done flushing control messages on " + this);
                                }
                                this.flushCtrl = false;
                                this.flushCtrlLock.notifyAll();
                                this.os.flush();
                            }
                            // MONITOREXIT : object4
                            if (this.flush) {
                                object4 = this.flushLock;
                                // MONITORENTER : object4
                                if (!this.isBusy() || !this.isValid()) {
                                    if (DEBUG) {
                                        this.logger.log(4, "Done flushing control messages on " + this);
                                    }
                                    this.flush = false;
                                    this.flushLock.notifyAll();
                                    this.os.flush();
                                }
                                // MONITOREXIT : object4
                            }
                            if (this.isValid()) return n5;
                            object4 = this;
                            // MONITORENTER : object4
                            if (this.waitingWritePkt != null) {
                                this.waitingWritePkt.destroy();
                            }
                            this.waitingWritePkt = null;
                            // MONITOREXIT : object4
                            return n5;
                        }
                        if (this.isBusy()) {
                            int n6 = 0;
                            Object var8_17 = null;
                            this.inWriteProcess = false;
                            Object object5 = this.flushCtrlLock;
                            // MONITORENTER : object5
                            if (this.flushCtrl && (this.ctrlpkt == null && this.control.isEmpty() || !this.isValid())) {
                                if (DEBUG) {
                                    this.logger.log(4, "Done flushing control messages on " + this);
                                }
                                this.flushCtrl = false;
                                this.flushCtrlLock.notifyAll();
                                this.os.flush();
                            }
                            // MONITOREXIT : object5
                            if (this.flush) {
                                object5 = this.flushLock;
                                // MONITORENTER : object5
                                if (!this.isBusy() || !this.isValid()) {
                                    if (DEBUG) {
                                        this.logger.log(4, "Done flushing control messages on " + this);
                                    }
                                    this.flush = false;
                                    this.flushLock.notifyAll();
                                    this.os.flush();
                                }
                                // MONITOREXIT : object5
                            }
                            if (this.isValid()) return n6;
                            object5 = this;
                            // MONITORENTER : object5
                            if (this.waitingWritePkt != null) {
                                this.waitingWritePkt.destroy();
                            }
                            this.waitingWritePkt = null;
                            // MONITOREXIT : object5
                            return n6;
                        }
                        int n7 = 1;
                        Object var8_18 = null;
                        this.inWriteProcess = false;
                        Object object6 = this.flushCtrlLock;
                        // MONITORENTER : object6
                        if (this.flushCtrl && (this.ctrlpkt == null && this.control.isEmpty() || !this.isValid())) {
                            if (DEBUG) {
                                this.logger.log(4, "Done flushing control messages on " + this);
                            }
                            this.flushCtrl = false;
                            this.flushCtrlLock.notifyAll();
                            this.os.flush();
                        }
                        // MONITOREXIT : object6
                        if (this.flush) {
                            object6 = this.flushLock;
                            // MONITORENTER : object6
                            if (!this.isBusy() || !this.isValid()) {
                                if (DEBUG) {
                                    this.logger.log(4, "Done flushing control messages on " + this);
                                }
                                this.flush = false;
                                this.flushLock.notifyAll();
                                this.os.flush();
                            }
                            // MONITOREXIT : object6
                        }
                        if (this.isValid()) return n7;
                        object6 = this;
                        // MONITORENTER : object6
                        if (this.waitingWritePkt != null) {
                            this.waitingWritePkt.destroy();
                        }
                        this.waitingWritePkt = null;
                        // MONITOREXIT : object6
                        return n7;
                    }
                    this.flushCritical = false;
                    if (DEBUG) {
                        this.logger.log(1, "IMQIPConnection[ {0} ] - processing  normal msg queue", this.toString());
                    }
                    if (!this.inJMSWrite && !this.hasCtrl) {
                        boolean bl3;
                        this.lockCritical = true;
                        boolean bl4 = false;
                        assert (this.waitingWritePkt != null);
                        if (this.hasCtrl || !this.runningMsgs || this.paused || this.waitingForResumeFlow || !(bl4 = this.fillNextPacket(this.waitingWritePkt))) {
                            Object object7 = this.stateLock;
                            // MONITORENTER : object7
                            this.checkState();
                            // MONITOREXIT : object7
                            if (this.isBusy()) {
                                int n8 = 0;
                                Object var8_19 = null;
                                this.inWriteProcess = false;
                                Object object8 = this.flushCtrlLock;
                                // MONITORENTER : object8
                                if (this.flushCtrl && (this.ctrlpkt == null && this.control.isEmpty() || !this.isValid())) {
                                    if (DEBUG) {
                                        this.logger.log(4, "Done flushing control messages on " + this);
                                    }
                                    this.flushCtrl = false;
                                    this.flushCtrlLock.notifyAll();
                                    this.os.flush();
                                }
                                // MONITOREXIT : object8
                                if (this.flush) {
                                    object8 = this.flushLock;
                                    // MONITORENTER : object8
                                    if (!this.isBusy() || !this.isValid()) {
                                        if (DEBUG) {
                                            this.logger.log(4, "Done flushing control messages on " + this);
                                        }
                                        this.flush = false;
                                        this.flushLock.notifyAll();
                                        this.os.flush();
                                    }
                                    // MONITOREXIT : object8
                                }
                                if (this.isValid()) return n8;
                                object8 = this;
                                // MONITORENTER : object8
                                if (this.waitingWritePkt != null) {
                                    this.waitingWritePkt.destroy();
                                }
                                this.waitingWritePkt = null;
                                // MONITOREXIT : object8
                                return n8;
                            }
                            int n9 = 1;
                            Object var8_20 = null;
                            this.inWriteProcess = false;
                            Object object9 = this.flushCtrlLock;
                            // MONITORENTER : object9
                            if (this.flushCtrl && (this.ctrlpkt == null && this.control.isEmpty() || !this.isValid())) {
                                if (DEBUG) {
                                    this.logger.log(4, "Done flushing control messages on " + this);
                                }
                                this.flushCtrl = false;
                                this.flushCtrlLock.notifyAll();
                                this.os.flush();
                            }
                            // MONITOREXIT : object9
                            if (this.flush) {
                                object9 = this.flushLock;
                                // MONITORENTER : object9
                                if (!this.isBusy() || !this.isValid()) {
                                    if (DEBUG) {
                                        this.logger.log(4, "Done flushing control messages on " + this);
                                    }
                                    this.flush = false;
                                    this.flushLock.notifyAll();
                                    this.os.flush();
                                }
                                // MONITOREXIT : object9
                            }
                            if (this.isValid()) return n9;
                            object9 = this;
                            // MONITORENTER : object9
                            if (this.waitingWritePkt != null) {
                                this.waitingWritePkt.destroy();
                            }
                            this.waitingWritePkt = null;
                            // MONITOREXIT : object9
                            return n9;
                        }
                        if (!bl4) {
                            int n10 = 0;
                            Object var8_21 = null;
                            this.inWriteProcess = false;
                            Object object10 = this.flushCtrlLock;
                            // MONITORENTER : object10
                            if (this.flushCtrl && (this.ctrlpkt == null && this.control.isEmpty() || !this.isValid())) {
                                if (DEBUG) {
                                    this.logger.log(4, "Done flushing control messages on " + this);
                                }
                                this.flushCtrl = false;
                                this.flushCtrlLock.notifyAll();
                                this.os.flush();
                            }
                            // MONITOREXIT : object10
                            if (this.flush) {
                                object10 = this.flushLock;
                                // MONITORENTER : object10
                                if (!this.isBusy() || !this.isValid()) {
                                    if (DEBUG) {
                                        this.logger.log(4, "Done flushing control messages on " + this);
                                    }
                                    this.flush = false;
                                    this.flushLock.notifyAll();
                                    this.os.flush();
                                }
                                // MONITOREXIT : object10
                            }
                            if (this.isValid()) return n10;
                            object10 = this;
                            // MONITORENTER : object10
                            if (this.waitingWritePkt != null) {
                                this.waitingWritePkt.destroy();
                            }
                            this.waitingWritePkt = null;
                            // MONITOREXIT : object10
                            return n10;
                        }
                        this.inJMSWrite = true;
                        if (this.convertPkt != null) {
                            this.convertPkt.handleWritePacket(this.waitingWritePkt);
                        }
                        ++this.sent_count;
                        boolean bl5 = bl3 = this.flowCount != 0 && this.sent_count >= this.flowCount;
                        if (bl3) {
                            this.sent_count = 0;
                            this.waitingWritePkt.setFlowPaused(bl3);
                            this.haltFlow();
                        }
                        if (DEBUG || DUMP_PACKET || OUT_DUMP_PACKET) {
                            int n11 = DUMP_PACKET || OUT_DUMP_PACKET ? 8 : 1;
                            this.logger.log(n11, "\n------------------------------\nSending JMS Packet -[block = " + this.BLOCKING + ",nio = " + !this.STREAMS + "] " + this + "  Dumping" + "\n" + this.waitingWritePkt.dumpPacketString("<<<<****") + "\n------------------------------");
                        }
                    }
                    if (this.inJMSWrite) {
                        if (this.STREAMS) {
                            this.waitingWritePkt.writePacket(this.os);
                            this.inJMSWrite = false;
                        } else {
                            this.inJMSWrite = !this.waitingWritePkt.writePacket(this.channel, this.BLOCKING);
                        }
                    }
                    this.lockCritical = false;
                    if (this.inJMSWrite) {
                        int n12 = 2;
                        Object var8_22 = null;
                        this.inWriteProcess = false;
                        Object object11 = this.flushCtrlLock;
                        // MONITORENTER : object11
                        if (this.flushCtrl && (this.ctrlpkt == null && this.control.isEmpty() || !this.isValid())) {
                            if (DEBUG) {
                                this.logger.log(4, "Done flushing control messages on " + this);
                            }
                            this.flushCtrl = false;
                            this.flushCtrlLock.notifyAll();
                            this.os.flush();
                        }
                        // MONITOREXIT : object11
                        if (this.flush) {
                            object11 = this.flushLock;
                            // MONITORENTER : object11
                            if (!this.isBusy() || !this.isValid()) {
                                if (DEBUG) {
                                    this.logger.log(4, "Done flushing control messages on " + this);
                                }
                                this.flush = false;
                                this.flushLock.notifyAll();
                                this.os.flush();
                            }
                            // MONITOREXIT : object11
                        }
                        if (this.isValid()) return n12;
                        object11 = this;
                        // MONITORENTER : object11
                        if (this.waitingWritePkt != null) {
                            this.waitingWritePkt.destroy();
                        }
                        this.waitingWritePkt = null;
                        // MONITOREXIT : object11
                        return n12;
                    }
                    ++this.msgsToConsumer;
                    if (this.waitingWritePkt.getPacketType() < 80) {
                        int n13 = this.waitingWritePkt.getPacketType();
                        this.pktsOut[n13] = this.pktsOut[n13] + 1;
                    }
                    if (Globals.getConnectionManager().PING_ENABLED) {
                        this.updateAccessTime(false);
                    }
                    if (this.METRICS_ON) {
                        this.countOutPacket(this.waitingWritePkt);
                    }
                    if (this.isBusy()) {
                        int n14 = 0;
                        Object var8_23 = null;
                        this.inWriteProcess = false;
                        Object object12 = this.flushCtrlLock;
                        // MONITORENTER : object12
                        if (this.flushCtrl && (this.ctrlpkt == null && this.control.isEmpty() || !this.isValid())) {
                            if (DEBUG) {
                                this.logger.log(4, "Done flushing control messages on " + this);
                            }
                            this.flushCtrl = false;
                            this.flushCtrlLock.notifyAll();
                            this.os.flush();
                        }
                        // MONITOREXIT : object12
                        if (this.flush) {
                            object12 = this.flushLock;
                            // MONITORENTER : object12
                            if (!this.isBusy() || !this.isValid()) {
                                if (DEBUG) {
                                    this.logger.log(4, "Done flushing control messages on " + this);
                                }
                                this.flush = false;
                                this.flushLock.notifyAll();
                                this.os.flush();
                            }
                            // MONITOREXIT : object12
                        }
                        if (this.isValid()) return n14;
                        object12 = this;
                        // MONITORENTER : object12
                        if (this.waitingWritePkt != null) {
                            this.waitingWritePkt.destroy();
                        }
                        this.waitingWritePkt = null;
                        // MONITOREXIT : object12
                        return n14;
                    }
                    n = 1;
                    Object var8_24 = null;
                    this.inWriteProcess = false;
                    object = this.flushCtrlLock;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Globals.handleGlobalError(outOfMemoryError, Globals.getBrokerResources().getKString("B0013"));
                    Object var8_25 = null;
                    this.inWriteProcess = false;
                    Object object13 = this.flushCtrlLock;
                    // MONITORENTER : object13
                    if (this.flushCtrl && (this.ctrlpkt == null && this.control.isEmpty() || !this.isValid())) {
                        if (DEBUG) {
                            this.logger.log(4, "Done flushing control messages on " + this);
                        }
                        this.flushCtrl = false;
                        this.flushCtrlLock.notifyAll();
                        this.os.flush();
                    }
                    // MONITOREXIT : object13
                    if (this.flush) {
                        object13 = this.flushLock;
                        // MONITORENTER : object13
                        if (!this.isBusy() || !this.isValid()) {
                            if (DEBUG) {
                                this.logger.log(4, "Done flushing control messages on " + this);
                            }
                            this.flush = false;
                            this.flushLock.notifyAll();
                            this.os.flush();
                        }
                        // MONITOREXIT : object13
                    }
                    if (!this.isValid()) {
                        object13 = this;
                        // MONITORENTER : object13
                        if (this.waitingWritePkt != null) {
                            this.waitingWritePkt.destroy();
                        }
                        this.waitingWritePkt = null;
                        // MONITOREXIT : object13
                    }
                    break block167;
                }
                catch (IOException iOException) {
                    this.logger.log(2, "closed connection " + this, iOException);
                    this.inJMSWrite = false;
                    this.destroyConnection(false, 5, Globals.getBrokerResources().getKString("B0061"));
                    throw iOException;
                }
                // MONITORENTER : object
                if (this.flushCtrl && (this.ctrlpkt == null && this.control.isEmpty() || !this.isValid())) {
                    if (DEBUG) {
                        this.logger.log(4, "Done flushing control messages on " + this);
                    }
                    this.flushCtrl = false;
                    this.flushCtrlLock.notifyAll();
                    this.os.flush();
                }
                // MONITOREXIT : object
                if (this.flush) {
                    object = this.flushLock;
                    // MONITORENTER : object
                    if (!this.isBusy() || !this.isValid()) {
                        if (DEBUG) {
                            this.logger.log(4, "Done flushing control messages on " + this);
                        }
                        this.flush = false;
                        this.flushLock.notifyAll();
                        this.os.flush();
                    }
                    // MONITOREXIT : object
                }
                if (this.isValid()) return n;
                object = this;
                // MONITORENTER : object
                if (this.waitingWritePkt != null) {
                    this.waitingWritePkt.destroy();
                }
                this.waitingWritePkt = null;
                // MONITOREXIT : object
                return n;
            }
            catch (Throwable throwable) {
                Object var8_26 = null;
                this.inWriteProcess = false;
                Object object = this.flushCtrlLock;
                // MONITORENTER : object
                if (this.flushCtrl && (this.ctrlpkt == null && this.control.isEmpty() || !this.isValid())) {
                    if (DEBUG) {
                        this.logger.log(4, "Done flushing control messages on " + this);
                    }
                    this.flushCtrl = false;
                    this.flushCtrlLock.notifyAll();
                    this.os.flush();
                }
                // MONITOREXIT : object
                if (this.flush) {
                    object = this.flushLock;
                    // MONITORENTER : object
                    if (!this.isBusy() || !this.isValid()) {
                        if (DEBUG) {
                            this.logger.log(4, "Done flushing control messages on " + this);
                        }
                        this.flush = false;
                        this.flushLock.notifyAll();
                        this.os.flush();
                    }
                    // MONITOREXIT : object
                }
                if (this.isValid()) throw throwable;
                object = this;
                // MONITORENTER : object
                if (this.waitingWritePkt != null) {
                    this.waitingWritePkt.destroy();
                }
                this.waitingWritePkt = null;
                // MONITOREXIT : object
                throw throwable;
            }
        }
        assert (false) : " should never happen";
        if (!this.isBusy()) return 1;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkState() {
        if (!$assertionsDisabled) {
            Thread.currentThread();
            if (!Thread.holdsLock(this.stateLock)) {
                throw new AssertionError();
            }
        }
        NFLPriorityFifoSet nFLPriorityFifoSet = this.control;
        synchronized (nFLPriorityFifoSet) {
            Set set = this.busySessions;
            synchronized (set) {
                boolean bl;
                boolean bl2 = bl = this.isValid() && (this.inCtrlWrite || !this.paused && !this.control.isEmpty() || this.inJMSWrite || this.runningMsgs && !this.waitingForResumeFlow && !this.busySessions.isEmpty());
                if (!this.isValid() || this.busy != bl) {
                    this.busy = bl;
                    this.stateLock.notifyAll();
                    if (this.ninfo != null) {
                        this.ninfo.setReadyToWrite(this, this.busy);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForWork(long l) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isValid() && !this.busy) {
                try {
                    if (l == 0L) {
                        this.stateLock.wait();
                    } else {
                        this.stateLock.wait(l);
                    }
                }
                catch (InterruptedException interruptedException) {
                    assert (false);
                    this.logger.logStack(8, "Internal error, got interrupted exception", interruptedException);
                }
            }
            return this.busy;
        }
    }

    private void sendReply(Packet packet, int n) {
        if (packet.getSendAcknowledge()) {
            Packet packet2 = new Packet(this.useDirectBuffers());
            packet2.setPacketType(9);
            packet2.setConsumerID(packet.getConsumerID());
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            hashtable.put("JMQStatus", new Integer(n));
            packet2.setProperties(hashtable);
            this.sendControlMessage(packet2);
        }
    }

    public void cleanupMemory(boolean bl) {
    }

    protected void sayGoodbye(int n, String string) {
        this.sayGoodbye(false, n, string);
    }

    protected void sayGoodbye(boolean bl, int n, String string) {
        Packet packet = new Packet(this.useDirectBuffers());
        packet.setPacketType(28);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("JMQExit", bl);
        hashtable.put("JMQGoodbyeReason", new Integer(n));
        hashtable.put("JMQGoodbyeReasonString", string);
        packet.setProperties(hashtable);
        this.sendControlMessage(packet);
    }

    protected void checkConnection() {
        boolean bl = false;
        if (enablePingReply && closeInterval > 0 && this.getClientProtocolVersion() >= 364) {
            long l;
            bl = true;
            long l2 = this.getLastResponseTime();
            long l3 = System.currentTimeMillis() - l2;
            if (l3 >= (l = (long)(ConnectionManager.pingTimeout * (closeInterval + 1)))) {
                this.logger.log(8, "B2173", (Object)String.valueOf(this.getConnectionUID().longValue()), String.valueOf(l3 / 1000L));
                this.destroyConnection(false, 3, "Connection unresponsive");
            }
        }
        Packet packet = new Packet(this.useDirectBuffers());
        packet.setPacketType(54);
        if (bl) {
            packet.setSendAcknowledge(true);
        }
        this.sendControlMessage(packet);
    }

    protected void flushConnection(long l) {
        this.flushControl(l);
    }

    public void flowPaused(long l) {
        if (Globals.getMemManager() != null) {
            Globals.getMemManager().notifyWhenAvailable(this, l);
        }
    }

    public void resumeMemory(int n, long l, long l2) {
        this.sendResume(n, l, l2, false);
    }

    public void updateMemory(int n, long l, long l2) {
        this.sendResume(n, l, l2, true);
    }

    protected void sendResume(int n, long l, long l2, boolean bl) {
        if (this.packetVersion < 103) {
            return;
        }
        Packet packet = new Packet(this.useDirectBuffers());
        packet.setPacketType(52);
        Hashtable<String, Number> hashtable = new Hashtable<String, Number>();
        if (Globals.getMemManager() != null) {
            hashtable.put("JMQSize", new Integer(Globals.getMemManager().getJMQSize()));
            hashtable.put("JMQBytes", new Long(Globals.getMemManager().getJMQBytes()));
            hashtable.put("JMQMaxMsgBytes", new Long(Globals.getMemManager().getJMQMaxMsgBytes()));
        }
        packet.setProperties(hashtable);
        this.sendControlMessage(packet, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventOccured(EventType eventType, Reason reason, Object object, Object object2, Object object3, Object object4) {
        Object object5 = this.stateLock;
        synchronized (object5) {
            if (eventType == EventType.EMPTY) {
                assert (object == this.control);
                assert (object3 instanceof Boolean);
                assert (object3 != null);
            } else if (eventType == EventType.BUSY_STATE_CHANGED) {
                assert (object instanceof Session);
                assert (object3 instanceof Boolean);
                assert (object3 != null);
                Session session = (Session)object;
                Set set = this.busySessions;
                synchronized (set) {
                    Object object6 = session.getBusyLock();
                    synchronized (object6) {
                        if (session.isBusy()) {
                            this.busySessions.add(session);
                        }
                    }
                }
            }
            this.checkState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fillNextPacket(Packet packet) {
        Session session = null;
        Set set = this.busySessions;
        synchronized (set) {
            Iterator iterator = this.busySessions.iterator();
            while (iterator.hasNext()) {
                session = (Session)iterator.next();
                iterator.remove();
                if (session == null) continue;
                Object object = session.getBusyLock();
                synchronized (object) {
                    if (session.isBusy()) {
                        this.busySessions.add(session);
                        break;
                    }
                }
            }
        }
        if (session == null) {
            return false;
        }
        return session.fillNextPacket(packet) != null;
    }

    static {
        try {
            ipAddress = InetAddress.getLocalHost().getAddress();
        }
        catch (Exception exception) {
            Globals.getLogger().log(8, "Internal Error, could not  retrieve local address ", (Object)ipAddress);
            ipAddress = new byte[0];
        }
        DEBUG = Globals.getConfig().getBooleanProperty("imq.packet.debug.info");
        DUMP_PACKET = Globals.getConfig().getBooleanProperty("imq.packet.debug.all");
        OUT_DUMP_PACKET = Globals.getConfig().getBooleanProperty("imq.packet.debug.out");
        IN_DUMP_PACKET = Globals.getConfig().getBooleanProperty("imq.packet.debug.in");
        OVERRIDE_CTRL_PACKET = false;
        OVERRIDE_READ_PACKET = false;
        OVERRIDE_FILL_PACKET = false;
        O_CTRL_USE_DIRECT = false;
        O_READ_USE_DIRECT = false;
        O_FILL_USE_DIRECT = false;
        try {
            String string;
            String string2;
            String string3 = Globals.getConfig().getProperty("imq.packet.ctrl.override");
            if (string3 != null && string3.trim().length() > 0) {
                if ((string3 = string3.trim()).equalsIgnoreCase("direct")) {
                    OVERRIDE_CTRL_PACKET = true;
                    O_CTRL_USE_DIRECT = true;
                    Globals.getLogger().log(4, "DEBUG: Overriding ctrl message  packet behavior to DIRECT BUFFERS");
                } else if (string3.equalsIgnoreCase("heap")) {
                    OVERRIDE_CTRL_PACKET = true;
                    O_CTRL_USE_DIRECT = false;
                    Globals.getLogger().log(4, "DEBUG: Overriding ctrl message  packet behavior to HEAP BUFFERS");
                } else {
                    Globals.getLogger().log(32, "DEBUG: Can not determine behavior from  imq.packet.ctrl.override = " + string3 + "  not one of the valid setting [heap,direct]");
                }
            }
            if ((string2 = Globals.getConfig().getProperty("imq.packet.read.override")) != null && string2.trim().length() > 0) {
                if ((string2 = string2.trim()).equalsIgnoreCase("direct")) {
                    OVERRIDE_READ_PACKET = true;
                    O_READ_USE_DIRECT = true;
                    Globals.getLogger().log(4, "DEBUG: Overriding read packet behavior to DIRECT BUFFERS");
                } else if (string2.equalsIgnoreCase("heap")) {
                    OVERRIDE_READ_PACKET = true;
                    O_READ_USE_DIRECT = false;
                    Globals.getLogger().log(4, "DEBUG: Overriding read packet  behavior to HEAP BUFFERS");
                } else {
                    Globals.getLogger().log(32, "DEBUG: Can not determine behavior from  imq.packet.read.override = " + string2 + "  not one of the valid setting [heap,direct]");
                }
            }
            if ((string = Globals.getConfig().getProperty("imq.packet.fill.override")) != null && string.trim().length() > 0) {
                if ((string = string.trim()).equalsIgnoreCase("direct")) {
                    OVERRIDE_FILL_PACKET = true;
                    O_FILL_USE_DIRECT = true;
                    Globals.getLogger().log(4, "DEBUG: Overriding fill packet  behavior to DIRECT BUFFERS");
                } else if (string.equalsIgnoreCase("heap")) {
                    OVERRIDE_FILL_PACKET = true;
                    O_FILL_USE_DIRECT = false;
                    Globals.getLogger().log(4, "DEBUG: Overriding fill packet  behavior to HEAP BUFFERS");
                } else {
                    Globals.getLogger().log(32, "DEBUG: Can not determine  behavior from jmq.packet.fill.override = " + string + "  not one of the valid setting [heap,direct]");
                }
            }
        }
        catch (Exception exception) {
            Globals.getLogger().logStack(4, "DEBUG: error setting overrides", exception);
        }
    }

    static class StateWatcher
    extends TimerTask {
        private int state;
        IMQIPConnection con = null;

        public StateWatcher(int n, IMQIPConnection iMQIPConnection) {
            this.state = n;
            this.con = iMQIPConnection;
        }

        public boolean cancel() {
            this.con = null;
            return super.cancel();
        }

        public void run() {
            this.con.checkConnection(this.state);
        }
    }
}

