/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterConsumerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolConsumerUIDIterator;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;

public class ClusterMessageInfo {
    protected Logger logger = Globals.getLogger();
    private PacketReference ref = null;
    private ArrayList consumers = null;
    private boolean sendMessageDeliveredAck = false;
    private Cluster c = null;
    private GPacket pkt = null;
    private DataInputStream dis = null;

    private ClusterMessageInfo(PacketReference packetReference, ArrayList arrayList, boolean bl, Cluster cluster) {
        this.ref = packetReference;
        this.consumers = arrayList;
        this.sendMessageDeliveredAck = bl;
        this.c = cluster;
    }

    private ClusterMessageInfo(GPacket gPacket, Cluster cluster) {
        this.pkt = gPacket;
        this.c = cluster;
    }

    public static ClusterMessageInfo newInstance(PacketReference packetReference, ArrayList arrayList, boolean bl, Cluster cluster) {
        return new ClusterMessageInfo(packetReference, arrayList, bl, cluster);
    }

    public static ClusterMessageInfo newInstance(GPacket gPacket, Cluster cluster) {
        return new ClusterMessageInfo(gPacket, cluster);
    }

    public GPacket getGPacket() {
        assert (this.ref != null);
        assert (this.consumers != null);
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)1);
        gPacket.putProp("D", this.sendMessageDeliveredAck);
        gPacket.putProp("C", new Integer(this.consumers.size()));
        this.c.marshalBrokerAddress(this.c.getSelfAddress(), gPacket);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        Packet packet = null;
        try {
            for (int i = 0; i < this.consumers.size(); ++i) {
                ConsumerUID consumerUID = ((Consumer)this.consumers.get(i)).getConsumerUID();
                ClusterConsumerInfo.writeConsumerUID(consumerUID, dataOutputStream);
            }
            if (packet == null) {
                packet = this.ref.getPacket();
            }
            packet.generateTimestamp(false);
            packet.generateSequenceNumber(false);
            packet.writePacket(dataOutputStream);
            dataOutputStream.flush();
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            this.logger.logStack(16, "Exception writing packet ", exception);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        gPacket.setPayload(ByteBuffer.wrap(byArray));
        return gPacket;
    }

    public String toString() {
        if (this.consumers == null || this.ref == null) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer("\n");
        if (this.consumers != null && this.ref != null) {
            for (int i = 0; i < this.consumers.size(); ++i) {
                ConsumerUID consumerUID = ((Consumer)this.consumers.get(i)).getConsumerUID();
                stringBuffer.append("\t").append(consumerUID).append("\n");
            }
        }
        return stringBuffer.toString();
    }

    public BrokerAddress getHomeBrokerAddress() throws Exception {
        assert (this.pkt != null);
        return this.c.unmarshalBrokerAddress(this.pkt);
    }

    public boolean getSendMessageDeliveredAck() {
        assert (this.pkt != null);
        return (Boolean)this.pkt.getProp("D");
    }

    public int getConsumerCount() {
        assert (this.pkt != null);
        return (Integer)this.pkt.getProp("C");
    }

    public void initPayloadRead() {
        assert (this.pkt != null);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.pkt.getPayload().array());
        this.dis = new DataInputStream(byteArrayInputStream);
    }

    public Iterator readPayloadConsumerUIDs() {
        assert (this.pkt != null);
        assert (this.dis != null);
        return new ProtocolConsumerUIDIterator(this.dis, this.getConsumerCount());
    }

    public Packet readPayloadMessage() throws IOException {
        assert (this.pkt != null);
        assert (this.dis != null);
        Packet packet = new Packet(false);
        packet.generateTimestamp(false);
        packet.generateSequenceNumber(false);
        packet.readPacket(this.dis);
        return packet;
    }

    public boolean needReply() {
        assert (this.pkt != null);
        return this.pkt.getBit(1);
    }

    public GPacket getReplyGPacket(int n) {
        assert (this.pkt != null);
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)2);
        gPacket.putProp("S", new Integer(n));
        return gPacket;
    }
}

