/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.multibroker.BrokerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterBrokerInfoReply;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class CommonProtocol
implements Protocol {
    private static boolean DEBUG = false;
    protected static final Logger logger = Globals.getLogger();
    protected MessageBusCallback cb = null;
    protected Cluster c = null;
    protected BrokerAddress selfAddress = null;
    protected Protocol realProtocol = null;
    protected boolean protocolInitComplete = false;
    protected long startTime = 0L;
    private Integer configServerVersion = null;
    private Object protocolInitWaitObject = new Object();

    public CommonProtocol(MessageBusCallback messageBusCallback, Cluster cluster, BrokerAddress brokerAddress) throws BrokerException {
        this.cb = messageBusCallback;
        this.c = cluster;
        this.selfAddress = brokerAddress;
        this.startTime = System.currentTimeMillis();
    }

    public int getHighestSupportedVersion() {
        return ProtocolGlobals.getCurrentVersion();
    }

    public int getClusterVersion() throws BrokerException {
        if (!this.getProtocolInitComplete()) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4241"), 503);
        }
        try {
            if (this.c.getConfigServer() != null && this.configServerVersion != null) {
                return this.configServerVersion;
            }
        }
        catch (Exception exception) {
            logger.logStack(16, "B3100", "getConfigServer()", (Throwable)exception);
        }
        return this.realProtocol.getClusterVersion();
    }

    private void initNewProtocol() {
        if (DEBUG) {
            logger.log(4, "Using RAPTOR cluster protocol.");
        }
        try {
            this.c.useGPackets(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.realProtocol = new RaptorProtocol(this.cb, this.c, this.selfAddress, this.getBrokerInfo());
            this.realProtocol.startClusterIO();
        }
        catch (Exception exception) {
            logger.logStack(16, "B3100", "Initializing the cluster protcol", (Throwable)exception);
        }
    }

    public BrokerInfo getBrokerInfo() {
        BrokerInfo brokerInfo = new BrokerInfo();
        brokerInfo.setBrokerAddr(this.selfAddress);
        brokerInfo.setStartTime(this.startTime);
        brokerInfo.setStoreDirtyFlag(false);
        brokerInfo.setClusterProtocolVersion(new Integer(ProtocolGlobals.getCurrentVersion()));
        if (Globals.getHAEnabled()) {
            brokerInfo.setHeartbeatHostAddress(Globals.getHeartbeatService().getHeartbeatHostAddress());
            brokerInfo.setHeartbeatPort(Globals.getHeartbeatService().getHeartbeatPort());
            brokerInfo.setHeartbeatInterval(Globals.getHeartbeatService().getHeartbeatInterval());
        }
        return brokerInfo;
    }

    public ClusterBrokerInfoReply getBrokerInfoReply(BrokerInfo brokerInfo) throws Exception {
        if (this.c.getConfigServer() != null) {
            ClusterBrokerInfoReply clusterBrokerInfoReply = ClusterBrokerInfoReply.newInstance(this.getBrokerInfo(), 0);
            return clusterBrokerInfoReply;
        }
        if (!this.getProtocolInitComplete()) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4241"), 503);
        }
        return this.realProtocol.getBrokerInfoReply(brokerInfo);
    }

    public int addBrokerInfo(BrokerInfo brokerInfo) {
        BrokerAddress brokerAddress;
        try {
            brokerAddress = this.c.getConfigServer();
        }
        catch (Exception exception) {
            logger.logStack(16, "B3100", "getConfigServer()", (Throwable)exception);
            return 1;
        }
        if (this.getProtocolInitComplete()) {
            int n = -1;
            try {
                n = this.getClusterVersion();
            }
            catch (Exception exception) {
                logger.log(16, "B3100", "Unable to get cluster protocol version for adding remote broker " + brokerInfo.getBrokerAddr());
                return 2;
            }
            Integer n2 = brokerInfo.getClusterProtocolVersion();
            if (n2 == null || n2 < n) {
                logger.log(32, "B3100", "Cluster protocol version " + n2 + " of remote broker " + brokerInfo.getBrokerAddr() + " is not allowed in the cluster that has cluster protocol version " + n);
                return 2;
            }
            return this.realProtocol.addBrokerInfo(brokerInfo);
        }
        if (brokerAddress != null && brokerAddress.equals(brokerInfo.getBrokerAddr())) {
            Integer n = brokerInfo.getClusterProtocolVersion();
            if (n == null || n < 350) {
                logger.log(32, "B3100", "Cluster protocol version " + (n == null ? "null" : n.toString()) + " of master broker " + brokerInfo.getBrokerAddr() + " is not supported");
                return 2;
            }
            this.initNewProtocol();
            this.configServerVersion = n;
            this.setProtocolInitComplete(true);
            return this.realProtocol.addBrokerInfo(brokerInfo);
        }
        return 1;
    }

    public void removeBrokerInfo(BrokerAddress brokerAddress) {
        if (this.realProtocol != null) {
            this.realProtocol.removeBrokerInfo(brokerAddress);
        }
    }

    public void setMatchProps(Properties properties) {
        this.c.setMatchProps(properties);
    }

    public void startClusterIO() {
        if (DEBUG) {
            logger.log(4, "CommonProtocol.startClusterIO()");
        }
        try {
            BrokerAddress brokerAddress = this.c.getConfigServer();
            if (brokerAddress == null || brokerAddress.equals(this.selfAddress)) {
                this.initNewProtocol();
                this.setProtocolInitComplete(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.c.start();
        }
        catch (Exception exception) {
            logger.logStack(32, "B4210", "cluster", exception.getMessage(), exception);
            Broker.getBroker().exit(1, Globals.getBrokerResources().getKString("B4210", "cluster", exception.getMessage()), 4);
        }
    }

    public void stopClusterIO(boolean bl) {
        if (this.realProtocol != null) {
            this.realProtocol.stopClusterIO(bl);
        }
        this.c.shutdown();
    }

    public void receiveUnicast(BrokerAddress brokerAddress, GPacket gPacket) {
        if (DEBUG) {
            logger.log(4, "receiveUnicast GPacket");
        }
        this.realProtocol.receiveUnicast(brokerAddress, gPacket);
    }

    public void receiveBroadcast(BrokerAddress brokerAddress, GPacket gPacket) {
        if (DEBUG) {
            logger.log(4, "receiveBroadcast GPacket");
        }
        this.realProtocol.receiveBroadcast(brokerAddress, gPacket);
    }

    public void receiveUnicast(BrokerAddress brokerAddress, int n, byte[] byArray) {
        if (DEBUG) {
            logger.log(4, "receiveUnicast");
        }
        this.realProtocol.receiveUnicast(brokerAddress, n, byArray);
    }

    public void receiveBroadcast(BrokerAddress brokerAddress, int n, byte[] byArray) {
        if (DEBUG) {
            logger.log(4, "receiveBroadcast");
        }
        this.realProtocol.receiveBroadcast(brokerAddress, n, byArray);
    }

    public boolean waitForConfigSync() {
        BrokerAddress brokerAddress = null;
        try {
            brokerAddress = this.c.getConfigServer();
        }
        catch (Exception exception) {
            return true;
        }
        if (brokerAddress == null) {
            return false;
        }
        if (brokerAddress.equals(this.selfAddress)) {
            return false;
        }
        if (!this.getProtocolInitComplete()) {
            return true;
        }
        return this.realProtocol.waitForConfigSync();
    }

    public void reloadCluster() {
        this.waitForProtocolInit();
        this.realProtocol.reloadCluster();
    }

    public void stopMessageFlow() throws IOException {
        this.realProtocol.stopMessageFlow();
    }

    public void resumeMessageFlow() throws IOException {
        this.realProtocol.resumeMessageFlow();
    }

    public void sendMessage(PacketReference packetReference, Collection collection, boolean bl) {
        this.realProtocol.sendMessage(packetReference, collection, bl);
    }

    public void sendMessageAck(BrokerAddress brokerAddress, SysMessageID sysMessageID, ConsumerUID consumerUID, int n, Map map, boolean bl) throws BrokerException {
        this.realProtocol.sendMessageAck(brokerAddress, sysMessageID, consumerUID, n, map, bl);
    }

    public void sendMessageAck2P(BrokerAddress brokerAddress, SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray, int n, Map map, Long l, boolean bl) throws BrokerException {
        this.realProtocol.sendMessageAck2P(brokerAddress, sysMessageIDArray, consumerUIDArray, n, map, l, bl);
    }

    public void sendClusterTransactionInfo(long l, BrokerAddress brokerAddress) {
        if (this.realProtocol == null) {
            return;
        }
        this.realProtocol.sendClusterTransactionInfo(l, brokerAddress);
    }

    public BrokerAddress lookupBrokerAddress(String string) {
        if (!this.getProtocolInitComplete()) {
            logger.log(16, Globals.getBrokerResources().getKString("B4241: lookup " + string));
            return null;
        }
        return this.realProtocol.lookupBrokerAddress(string);
    }

    public void clientClosed(ConnectionUID connectionUID, boolean bl) {
        if (this.realProtocol == null) {
            return;
        }
        this.realProtocol.clientClosed(connectionUID, bl);
    }

    public int lockSharedResource(String string, ConnectionUID connectionUID) {
        if (!this.getProtocolInitComplete()) {
            return 0;
        }
        return this.realProtocol.lockSharedResource(string, connectionUID);
    }

    public int lockResource(String string, long l, ConnectionUID connectionUID) {
        if (!this.getProtocolInitComplete()) {
            return 0;
        }
        return this.realProtocol.lockResource(string, l, connectionUID);
    }

    public void unlockResource(String string) {
        if (!this.getProtocolInitComplete()) {
            return;
        }
        this.realProtocol.unlockResource(string);
    }

    public void recordUpdateDestination(Destination destination) throws BrokerException {
        this.waitForProtocolInit();
        this.realProtocol.recordUpdateDestination(destination);
    }

    public void recordRemoveDestination(Destination destination) throws BrokerException {
        this.waitForProtocolInit();
        this.realProtocol.recordRemoveDestination(destination);
    }

    public void sendNewDestination(Destination destination) throws BrokerException {
        this.waitForProtocolInit();
        this.realProtocol.sendNewDestination(destination);
    }

    public void sendRemovedDestination(Destination destination) throws BrokerException {
        this.waitForProtocolInit();
        this.realProtocol.sendRemovedDestination(destination);
    }

    public void sendUpdateDestination(Destination destination) throws BrokerException {
        this.waitForProtocolInit();
        this.realProtocol.sendUpdateDestination(destination);
    }

    public void recordCreateSubscription(Subscription subscription) throws BrokerException {
        this.waitForProtocolInit();
        this.realProtocol.recordCreateSubscription(subscription);
    }

    public void recordUnsubscribe(Subscription subscription) throws BrokerException {
        this.waitForProtocolInit();
        this.realProtocol.recordUnsubscribe(subscription);
    }

    public void sendNewSubscription(Subscription subscription, Consumer consumer, boolean bl) throws BrokerException {
        if (this.realProtocol == null) {
            return;
        }
        this.realProtocol.sendNewSubscription(subscription, consumer, bl);
    }

    public void sendNewConsumer(Consumer consumer, boolean bl) throws BrokerException {
        if (this.realProtocol == null) {
            return;
        }
        this.realProtocol.sendNewConsumer(consumer, bl);
    }

    public void sendRemovedConsumer(Consumer consumer, Set set, boolean bl) throws BrokerException {
        if (this.realProtocol == null) {
            return;
        }
        this.realProtocol.sendRemovedConsumer(consumer, set, bl);
    }

    public void handleGPacket(MessageBusCallback messageBusCallback, BrokerAddress brokerAddress, GPacket gPacket) {
        if (this.realProtocol == null) {
            logger.logStack(32, "No protocol", new Exception("No protocol"));
            return;
        }
        this.realProtocol.handleGPacket(messageBusCallback, brokerAddress, gPacket);
    }

    public void preTakeover(String string, UID uID, String string2, UID uID2) throws BrokerException {
        if (this.realProtocol == null) {
            logger.logStack(32, "No protocol", new Exception("No protocol"));
            return;
        }
        this.realProtocol.preTakeover(string, uID, string2, uID2);
    }

    public void postTakeover(String string, UID uID, boolean bl) {
        if (this.realProtocol == null) {
            logger.logStack(32, "No protocol", new Exception("No protocol"));
            return;
        }
        this.realProtocol.postTakeover(string, uID, bl);
    }

    public Hashtable getDebugState() {
        if (this.realProtocol == null) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("protocol", "No protocol yet");
            return hashtable;
        }
        return this.realProtocol.getDebugState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForProtocolInit() {
        Object object = this.protocolInitWaitObject;
        synchronized (object) {
            while (!this.getProtocolInitComplete()) {
                try {
                    logger.log(8, "B1264");
                    this.protocolInitWaitObject.wait(60000L);
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getProtocolInitComplete() {
        Object object = this.protocolInitWaitObject;
        synchronized (object) {
            return this.protocolInitComplete;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProtocolInitComplete(boolean bl) {
        Object object = this.protocolInitWaitObject;
        synchronized (object) {
            this.protocolInitComplete = bl;
            this.protocolInitWaitObject.notifyAll();
        }
    }
}

