/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQIPConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.UniqueID;
import com.sun.messaging.jmq.util.log.Logger;
import java.nio.ByteBuffer;
import java.util.Hashtable;

public class GenerateUIDHandler
extends PacketHandler {
    private Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        ByteBuffer byteBuffer;
        Hashtable<String, Object> hashtable;
        block9: {
            block8: {
                if (DEBUG) {
                    this.logger.log(1, "GenerateUIDHandler: handle() [ Received GenerateUID Packet]");
                }
                hashtable = null;
                try {
                    hashtable = packet.getProperties();
                }
                catch (Exception exception) {
                    this.logger.log(8, "Internal Error: unable to retrieve  properties from generateUID message " + packet, exception);
                    hashtable = new Hashtable<String, Object>();
                }
                Integer n = null;
                int n2 = 1;
                if (hashtable != null && (n = (Integer)hashtable.get("JMQQuantity")) != null) {
                    n2 = n;
                }
                int n3 = 200;
                int n4 = n2 * 8;
                byteBuffer = ByteBuffer.allocate(n4);
                short s = UID.getPrefix();
                for (int i = 0; i < n2; ++i) {
                    byteBuffer.putLong(UniqueID.generateID(s));
                }
                hashtable = new Hashtable();
                hashtable.put("JMQStatus", new Integer(n3));
                hashtable.put("JMQQuantity", new Integer(n2));
                IMQIPConnection cfr_ignored_0 = (IMQIPConnection)iMQConnection;
                if (IMQIPConnection.getDumpPacket()) break block8;
                IMQIPConnection cfr_ignored_1 = (IMQIPConnection)iMQConnection;
                if (!IMQIPConnection.getDumpOutPacket()) break block9;
            }
            hashtable.put("JMQReqID", packet.getSysMessageID().toString());
        }
        Packet packet2 = new Packet(iMQConnection.useDirectBuffers());
        packet2.setPacketType(63);
        packet2.setConsumerID(packet.getConsumerID());
        packet2.setProperties(hashtable);
        byteBuffer.rewind();
        packet2.setMessageBody(byteBuffer);
        iMQConnection.sendControlMessage(packet2);
        return true;
    }
}

