/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.UniqueID;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.Serializable;

public class ConsumerUID
extends UID
implements Externalizable,
Serializable {
    static final long serialVersionUID = 471544583389431969L;
    protected transient int ackType = 0;
    protected transient ConnectionUID conuid = null;
    protected transient BrokerAddress brokeraddr = Globals.getMyAddress();
    protected transient boolean shouldStore = false;

    public ConsumerUID() {
    }

    public ConsumerUID(long l) {
        super(l);
    }

    public ConsumerUID(boolean bl) {
        super(0L);
        if (!bl) {
            this.initializeID();
        }
    }

    public boolean shouldStore() {
        return this.shouldStore;
    }

    public void setShouldStore(boolean bl) {
        this.shouldStore = bl;
    }

    public ConsumerUID(int n) {
        super(n);
    }

    public boolean isEmpty() {
        return this.id == 0L;
    }

    public void initializeID() {
        if (this.id == 0L) {
            this.id = UniqueID.generateID(prefix);
        }
    }

    public void clear() {
        this.id = 0L;
        this.conuid = null;
        this.brokeraddr = null;
        this.ackType = 0;
    }

    public void updateUID(ConsumerUID consumerUID) {
        this.id = consumerUID.id;
    }

    public void copy(ConsumerUID consumerUID) {
        this.id = consumerUID.id;
        this.conuid = consumerUID.conuid;
        this.brokeraddr = consumerUID.brokeraddr;
        this.ackType = consumerUID.ackType;
    }

    public boolean isAutoAck() {
        return this.ackType == 1;
    }

    public int getAckType() {
        return this.ackType;
    }

    public String getAckMode() {
        switch (this.ackType) {
            case 1: {
                return "AUTO_ACKNOWLEDGE";
            }
            case 3: {
                return "DUPS_OK_ACKNOWLEDGE";
            }
            case 2: {
                return "CLIENT_ACKNOWLEDGE";
            }
            case 32768: {
                return "NO_ACK_ACKNOWLEDGE";
            }
        }
        return "NONE";
    }

    public boolean isDupsOK() {
        return this.ackType == 3;
    }

    public boolean isNoAck() {
        return this.ackType == 32768;
    }

    public boolean isUnsafeAck() {
        return this.isDupsOK() || this.isNoAck();
    }

    public void setAckType(int n) {
        this.ackType = n;
    }

    public void setConnectionUID(ConnectionUID connectionUID) {
        this.conuid = connectionUID;
    }

    public ConnectionUID getConnectionUID() {
        return this.conuid;
    }

    public void setBrokerAddress(BrokerAddress brokerAddress) {
        this.brokeraddr = brokerAddress;
    }

    public BrokerAddress getBrokerAddress() {
        if (this.brokeraddr == null) {
            this.brokeraddr = Globals.getMyAddress();
        }
        return this.brokeraddr;
    }

    public boolean isLocal() {
        return this.brokeraddr == null || this.brokeraddr == Globals.getMyAddress();
    }

    public String toString() {
        return "[consumer:" + super.toString() + ", type=" + this.getAckMode() + "]";
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.id = objectInput.readLong();
        this.ackType = 0;
        this.conuid = null;
        this.brokeraddr = Globals.getMyAddress();
        this.shouldStore = false;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.id);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.ackType = 0;
        this.conuid = null;
        this.brokeraddr = Globals.getMyAddress();
        this.shouldStore = false;
    }
}

