/*
 * @(#)registry.h	1.4 02/02/14
 * 
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 * 
 */

#ifndef _REGISTRY_H
#define _REGISTRY_H

#define JREHOME_KEY    "JREHome"
#define JVMARGS_KEY     "JVMArgs"
#define SERVICEARGS_KEY "ServiceArgs"
/* ####jes-windev#### start ## changing the SERVICE_NAME from iMQ_Broker to MQ_Broker and DISPLAY_NAME from iMQ Broker to Message Queue Broker */ 
#define SERVICE_NAME                "MQ_Broker"
#define DISPLAY_NAME                "Message Queue Broker"
/* ####jes-windev#### end */
#define PARAM_KEY_PATH  "SYSTEM\\CurrentControlSet\\Services\\" SERVICE_NAME "\\Parameters"

#ifdef __cplusplus
extern "C" {
#endif

extern char *vm_libs[];
extern int nvm_libs;

/************************************************************************
 *
 * saveStringInRegistry()
 *
 * value - Char array holding '\0' terminated string to save
 * value_size - size of 'value' parameter including terminating '\0'
 * key - subKey to hold value in. E.g. "VMArgs"
 *
 * Returns
 *     ERROR_SUCCESS on success
 *     Winerror.h error on failure
 ************************************************************************/
extern int saveStringInRegistry(const char *value, long value_size, const char* key);

/************************************************************************
 *
 * getStringFromRegistry()
 *
 * value - Char array to place string value in
 * value_size - size of 'value' parameter including terminating '\0'. 
 *              Upon return this will contain the number of bytes of data
 *              retrieved.
 * key - subKey to get value from. E.g. "VMArgs"
 *
 * Returns
 *     ERROR_SUCCESS on success
 *     Winerror.h error on failure
 ************************************************************************/
extern int getStringFromRegistry(char *value, long *value_size, const char* key);

#ifdef __cplusplus
}
#endif

#endif
