#!/bin/sh
#
# @(#)dbmgr.sh	1.17 01/17/05
#
# Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
# SUN PROPRIETARY/CONFIDENTIAL
# Use is subject to license terms. 
#
# IMQ Database Administration startup script: Developer Edition
#
# This is a a version of the database administration startup script
# that works when run in the "binary" directory (as opposed to "dist").
# It uses the loose class files and not the jars
#
# Parse Arguments 
#
#  -imqhome -> sets imq home
#  -imqvarhome -> sets imq var home
#  -javahome -> sets javahome
#

bin_home=`dirname $0`

imq_home=$bin_home/..
imq_varhome=$bin_home/../var

javacmd=java
# #####hpux-dev#####
PLATFORM=`uname`
if [ "$PLATFORM" = HP-UX ] ; then
javahome=${_JAVA_HOME:-/usr/jdk/entsys-j2se}
else
javahome=${_JAVA_HOME:-/net/jpgserv/usr/java1.5}
fi

while [ $# != 0 ]; do
  case "$1" in
    -imqhome) imq_home=$2; shift 2;;
    -imqvarhome) imq_varhome=$2 ; jvm_args="$jvm_args -Dimq.varhome=$imq_varhome"; shift 2;;
    -javahome) javahome=$2; shift 2;;
    *)  args="$args $1"; shift  ;;
  esac
done

javacmd=$javahome/bin/$javacmd

jvm_args="$jvm_args -Dimq.home=$imq_home"

_classes=$imq_home/../../share/opt/classes

# Additional classes possibly needed for JDBC provider
_classes=$_classes:$imq_home/lib/ext
# Put all jar and zip files in $imq_home/lib/ext in the classpath
for file in $imq_home/lib/ext/*.jar $imq_home/lib/ext/*.zip; do
    if [ -r "$file" ]; then
	_classes=$_classes:$file
    fi
done

_mainclass=com.sun.messaging.jmq.jmsserver.persist.jdbc.DBTool

# Needed to locate libimq
#####hpux-dev#####
if [ "$PLATFORM" = HP-UX ] ; then
SHLIB_PATH=$SHLIB_PATH:$imq_home/lib; export SHLIB_PATH
else
LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$imq_home/lib; export LD_LIBRARY_PATH
fi

$javacmd -cp $_classes $jvm_args $_mainclass $args
