#!/bin/sh
#
# @(#)broker.sh	1.41 01/17/05
#
# Copyright 2004 Sun Microsystems, Inc. All Rights Reserved
#
# @(#)broker.sh	1.41 05/01/17
#
# SUN PROPRIETARY/CONFIDENTIAL
# Use is subject to license terms. 
#
# Broker startup script: Developer Edition
#
# This is a a version of the broker startup script that works when
# run in the "binary" directory (as opposed to "dist"). It uses the
# loose class files and not the jars
#
# Parse Arguments 
#
#  -jmqhome -> sets jmq home
#  -jmqvarhome -> sets jmq var home
#  -javahome -> sets javahome
#

#def_jvm_args="-Djava.compiler=NONE -Xms8m -Xmx128m -Xss128k";
def_jvm_args="-server -Xms32m -Xmx192m -Xss128k";

bin_home=`dirname $0`

imq_home=$bin_home/..
imq_varhome=$bin_home/../var

javacmd=java

# #####hpux-dev#####
PLATFORM=`uname`
if [ "$PLATFORM" = HP-UX ] ; then
javahome=${_JAVA_HOME:-/usr/jdk/entsys-j2se}
else
javahome=${_JAVA_HOME:-/net/jpgserv/usr/java1.5}
fi

while [ $# != 0 ]; do
  case "$1" in
    -jmqhome) shift; imq_home=$1; shift ;;
    -jmqvarhome) shift; imq_varhome=$1 ; jvm_args="$jvm_args -Dimq.varhome=$imq_varhome"; shift  ;;
    -varhome) shift; imq_varhome=$1 ; jvm_args="$jvm_args -Dimq.varhome=$imq_varhome"; shift  ;;
    -javahome) shift;  javahome=$1; shift;;
    -jrehome) shift; javahome=$1; shift;;
    -vm) shift; jvm_args="$jvm_args $1"; shift ;;
    -vmargs) shift; jvm_args="$jvm_args $1"; shift ;;
    *)  args="$args $1"; shift  ;;
  esac
done

javacmd=$javahome/bin/$javacmd

jvm_args="$def_jvm_args $jvm_args -Dimq.home=$imq_home"

jmq_ext_jars_dir=${JMQ_EXTERNAL:-/net/jpgserv/export/jmq/external}
jsse_jars_dir=$jmq_ext_jars_dir/jsse/lib
jdmk_jars_dir=$jmq_ext_jars_dir/jdmk/lib
jesmf_jars_dir=$jmq_ext_jars_dir/jesmfb12/lib

_classes=$imq_home/../../share/opt/classes:$jsse_jars_dir/jcert.jar:$jsse_jars_dir/jnet.jar:$jsse_jars_dir/jsse.jar:/usr/lib/audit/Audit.jar:$jdmk_jars_dir/jdmkrt.jar:$jesmf_jars_dir/mfwk_instrum_tk.jar

# Additional classes possibly needed for JDBC provider
_classes=$_classes:$imq_home/lib/ext
# Put all jar and zip files in $imq_home/lib/ext in the classpath
for file in $imq_home/lib/ext/*.jar $imq_home/lib/ext/*.zip; do
    if [ -r "$file" ]; then
	_classes=$_classes:$file
    fi
done

# Needed to locate libimq
#####hpux-dev#####
if [ "$PLATFORM" = HP-UX ] ; then
SHLIB_PATH=$SHLIB_PATH:$imq_home/lib; export SHLIB_PATH
else
LD_LIBRARY_PATH=$imq_home/lib:$LD_LIBRARY_PATH; export LD_LIBRARY_PATH
fi

# Restart loop. If the Broker exits with 255 then restart it
restart=true
while [ $restart ]; do
    $javacmd -cp $_classes $jvm_args com.sun.messaging.jmq.jmsserver.Broker $args
    status=$?

    if [ $status -eq 255 ]; then
	# We pause to avoid pegging system if we get here accidentally
	sleep 1
    else
	restart=
    fi
done

exit $status
