/*
 * @(#)LocalTransaction.java	1.4 05/05/13
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved.
 * SUN PROPRIETARY/CONFIDENTIAL.
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jms.ra;

import javax.jms.*;

import javax.resource.*;
import javax.resource.spi.*;

import java.util.Vector;
import java.util.logging.Logger;

import com.sun.messaging.jmq.jmsclient.ConnectionImpl;


/**
 * Implements the LocalTransaction interface for the
 * S1 MQ RA.
 *
 * @author George Tharakan
 */

public class LocalTransaction
implements javax.resource.spi.LocalTransaction
{
    /** The connection event listener list */
    private Vector listeners = null;

    /** The ManagedConnection associated with this LocalTransaction */
    private com.sun.messaging.jms.ra.ManagedConnection mc = null;
    private ConnectionImpl xac = null;

    private long transactionID = -1L;
 
    protected boolean started = false;
    protected boolean active = false;
 


    /** Constructor */
    public LocalTransaction(com.sun.messaging.jms.ra.ManagedConnection mc, ConnectionImpl xac)
    {
        //System.out.println("MQRA:LT:Constr");
        this.mc = mc;
        this.xac = xac;
    }

    /** Begin a local transaction */
    public synchronized void
    begin()
    throws ResourceException
    {
        //System.out.println("MQRA:LT:begin()");
        try {
            if (!xac._isClosed()) {
                transactionID = xac.getProtocolHandler().startTransaction(transactionID, -1, null);
            } else {
                ResourceException re = new EISSystemException("MQRA:LT:startTransaction exception:Connection is closed");
                throw re;
            }
            //mc.getConnectionAdapter().getSessionAdapter().startLocalTransaction();
        } catch (Exception ex) {
            ResourceException re = new EISSystemException("MQRA:LT:startTransaction exception:"+
                ex.getMessage());
            re.initCause(ex);
            throw re;
        }
        started = true;
        active = true;
        mc.setLTActive(true);
    }

    /** Commit a local transaction */
    public synchronized void
    commit()
    throws ResourceException
    {
        //System.out.println("MQRA:LT:commit()");
        try {
            if (!xac._isClosed()) {
                xac.getProtocolHandler().commit(transactionID, -1, null);
            } else {
                ResourceException re = new EISSystemException("MQRA:LT:commitTransaction exception:Connection is closed");
                throw re;
            }
        } catch (Exception ex) {
            ResourceException re = new EISSystemException("MQRA:LT:commit exception:"+
                ex.getMessage());
            re.initCause(ex);
            throw re;
        } finally {
            mc.setLTActive(false);
            started = false;
            active = false;
        }
    }

    /** Rollback a local transaction */
    public synchronized void
    rollback()
    throws ResourceException
    {
        //System.out.println("MQRA:LT:rollback()");
        try {
            if (!xac._isClosed()) {
                xac.getProtocolHandler().rollback(transactionID, null);
            } else {
                ResourceException re = new EISSystemException("MQRA:LT:rillbackTransaction exception:Connection is closed");
                throw re;
            }
        } catch (Exception ex) {
            ResourceException re = new EISSystemException("MQRA:LT:rollback exception:"+
                ex.getMessage());
            re.initCause(ex);
            throw re;
        } finally {
            mc.setLTActive(false);
            started = false;
            active = false;
        }
    }

    public synchronized long getTransactionID() {
        return transactionID;
    }

    public boolean started() {
        return started;
    }

    public boolean isActive() {
        return active;
    }
}

