/*
 * @(#)EventListener.java	1.1 05/03/15
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */
package com.sun.messaging.jms.notification;


/**
 * An event listener object is used to receive asynchronously delivered MQ
 * events.
 * <p>
 * MQ client runtime may notify an application about a specific MQ event if
 * one has been set to the MQ connection.
 *
 * @author chiaming yang
 * @version 4.0
 */
public interface EventListener extends java.util.EventListener {

    /**
     * Notify a MQ application of a MQ event.
     *
     * @param event the event generated by MQ runtime.
     */
    public void onEvent (Event event);
}
