
/*
 * @(#)TransactionNotification.java	1.5 05/09/12
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jms.management.server;

import javax.management.Notification;

/**
 * Class containing information on transaction notifications.
 *
 * <P>
 * The MQ specific fields in this notification is TBD.
 *
 * @version     1.5 05/09/12
 * @author      Isa Hashim
 */
public class TransactionNotification extends MQNotification  {
    /** 
     * A transaction was committed.
     */
    public static final String		TRANSACTION_COMMIT = MQNotification.PREFIX + "transaction.commit";

    /** 
     * A transaction has entered the prepared state.
     */
    public static final String		TRANSACTION_PREPARE = MQNotification.PREFIX + "transaction.prepare";

    /** 
     * A transaction was rolled back.
     */
    public static final String		TRANSACTION_ROLLBACK = MQNotification.PREFIX + "transaction.rollback";

    private String id;

    
    /**
     * Creates a TransactionNotification object.
     *
     * @param type		The notification type.
     * @param source		The notification source.
     * @param sequenceNumber	The notification sequence number within the source object.
     */
    public TransactionNotification(String type, Object source, long sequenceNumber) {
	super(type, source, sequenceNumber);
    }

    public void setTransactionID(String id)  {
	this.id = id;
    }
    public String getTransactionID()  {
	return(id);
    }
    
}
