
/*
 * @(#)ConsumerInfo.java	1.1 06/01/19
 *
 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jms.management.server;

/**
 * This class contains constants/names for fields in the CompositeData
 * that is returned by the operations of the Consumer Manager Monitor 
 * MBean.
 *
 * @version     1.1 06/01/19
 * @author      Isa Hashim
 */
public class ConsumerInfo implements java.io.Serializable  {
    /** 
     * Acknowledge mode
     */
    public static final String		ACKNOWLEDGE_MODE = "AcknowledgeMode";

    /** 
     * Acknowledge mode label
     */
    public static final String		ACKNOWLEDGE_MODE_LABEL 
							= "AcknowledgeModeLabel";

    /** 
     * Client ID
     */
    public static final String		CLIENT_ID = "ClientID";

    /** 
     * Connection ID
     */
    public static final String		CONNECTION_ID = "ConnectionID";

    /** 
     * Consumer ID
     */
    public static final String		CONSUMER_ID = "ConsumerID";

    /** 
     * Destination Name
     */
    public static final String		DESTINATION_NAME = "DestinationName";

    /** 
     * Destination Type
     */
    public static final String		DESTINATION_TYPE = "DestinationType";

    /** 
     * Durable (whether the consume is a durable or not)
     */
    public static final String		DURABLE = "Durable";

    /** 
     * DurableActive (whether the durable is active or not)
     */
    public static final String		DURABLE_ACTIVE = "DurableActive";

    /** 
     * Durable name
     */
    public static final String		DURABLE_NAME = "DurableName";

    /** 
     * Flow Paused
     */
    public static final String		FLOW_PAUSED = "FlowPaused";

    /** 
     * Host
     */
    public static final String		HOST = "Host";

    /** 
     * Last acknowledge time
     */
    public static final String		LAST_ACK_TIME = "LastAckTime";

    /** 
     * Number of messages held for consumer.
     */
    public static final String		NUM_MSGS = "NumMsgs";

    /** 
     * Number of messages still held for consumer because
     * acks for them from the consumer are still pending.
     */
    public static final String		NUM_MSGS_PENDING_ACKS 
						= "NumMsgsPendingAcks";

    /** 
     * Selector
     */
    public static final String		SELECTOR = "Selector";

    /** 
     * Service Name
     */
    public static final String		SERVICE_NAME = "ServiceName";

    /** 
     * User
     */
    public static final String		USER = "User";
    /*
     * Class cannot be instantiated
     */
    private ConsumerInfo() {
    }
}
