
/*
 * @(#)ConnectionNotification.java	1.7 06/01/25
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jms.management.server;

import javax.management.Notification;

/**
 * Class containing information on cluster operations.
 *
 * <P>
 * The MQ specific fields in this notification is TBD.
 *
 * @version     1.7 06/01/25
 * @author      Isa Hashim
 */
public class ConnectionNotification extends MQNotification  {
    /** 
     * A connection was created.
     */
    public static final String		CONNECTION_OPEN = MQNotification.PREFIX + "connection.open";

    /** 
     * A connection was closed.
     */
    public static final String		CONNECTION_CLOSE = MQNotification.PREFIX + "connection.close";

    /** 
     * A connection was rejected.
     */
    public static final String		CONNECTION_REJECT = MQNotification.PREFIX + "connection.reject";

    private String id;
    private String serviceName, userName, remoteHost;

    
    /**
     * Creates a ConnectionNotification object.
     *
     * @param type		The notification type.
     * @param source		The notification source.
     * @param sequenceNumber	The notification sequence number within the source object.
     */
    public ConnectionNotification(String type, Object source, long sequenceNumber) {
	super(type, source, sequenceNumber);
    }

    public void setConnectionID(String id)  {
	this.id = id;
    }
    public String getConnectionID()  {
	return(id);
    }

    public void setServiceName(String serviceName)  {
	this.serviceName = serviceName;
    }
    public String getServiceName()  {
	return(serviceName);
    }

    public void setUserName(String userName)  {
	this.userName = userName;
    }
    public String getUserName()  {
	return(userName);
    }

    public void setRemoteHost(String remoteHost)  {
	this.remoteHost = remoteHost;
    }
    public String getRemoteHost()  {
	return(remoteHost);
    }
    
}
