
/*
 * @(#)ClusterOperations.java	1.3 05/09/06
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jms.management.server;

/**
 * Class containing information on cluster operations.
 *
 * @version     1.3 05/09/06
 * @author      Isa Hashim
 */
public class ClusterOperations {
    /** 
     * Get addresses for all brokers in cluster.
     */
    public static final String		GET_BROKER_ADDRESSES = "getBrokerAddresses";

    /** 
     * Get IDs for all brokers in cluster.
     */
    public static final String		GET_BROKER_IDS = "getBrokerIDs";

    /** 
     * Get info on all brokers in cluster.
     */
    public static final String		GET_BROKER_INFO = "getBrokerInfo";

    /** 
     * Get info on specified broker (via address) in cluster.
     */
    public static final String		GET_BROKER_INFO_BY_ADDRESS = "getBrokerInfoByAddress";

    /** 
     * Get info on specified broker (via ID) in cluster.
     */
    public static final String		GET_BROKER_INFO_BY_ID = "getBrokerInfoByID";

    /** 
     * Cluster reload operation.
     */
    public static final String		RELOAD = "reload";

    /*
     * Class cannot be instantiated
     */
    private ClusterOperations() {
    }
    
}
