/*
 * @(#)ConsumerInfo.java	1.5 00/12/13
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 *
 */

package com.sun.messaging.jmq.util.admin;

import com.sun.messaging.jmq.util.DestType;

/**
 * ConsumerInfo encapsulates information about a JMQ Consumer.
 * It is used to pass this information between the Broker and an
 * administration client.
 *
 * This class has no updateable fields. The admin client should consider
 * it "read-only"
 *
 * @version	1.5
 *
 */
public class ConsumerInfo extends AdminInfo implements java.io.Serializable {

    /**
     * Broker internal consumer ID
     */
    public byte[]	id;

    /**
     * Destination the consumer is registered on
     */
    public String	destination;

    /**
     * Type of destination. Set at creation only. Should be a combination
     * of bitmasks defined by DestType
     */
    public int		type;


    /**
     * Selector this consumer is using
     */
    public String	selector;

    /**
     * Information about the connection this consumer is on
     */
    public ConnectionInfo	connection;

    /**
     * Constructor for Consumer.
     */

    public ConsumerInfo() {
	reset();
    }

    public void reset() {
	id = null;
        type = 0;
        destination = null;
        selector = null;
	connection = null;
    }

    /**
     * Return a string representation of the consumer.
     *
     * @return String representation of the consumer.
     */
    public String toString() {

	return "Consumer: destination=" + destination +
            ":" + DestType.toString(type) +" connection=" +
	    (connection == null? "remote consumer" :connection.toString());
    }

}
