/*
 * @(#)ConnectionInfo.java	1.7 03/04/01
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 *
 */

package com.sun.messaging.jmq.util.admin;

import com.sun.messaging.jmq.io.MetricCounters;

/**
 * ConnectionInfo encapsulates information about a JMQ Connection. It is used
 * to pass this information between the Broker and an administration client.
 *
 * This class has no updateable fields. The admin client should consider
 * it "read-only"
 *
 * @version	1.7
 *
 */
public class ConnectionInfo extends AdminInfo implements java.io.Serializable {

    /**
     * Broker internal connection ID.
     */
    public byte[]	id;

    /**
     * Connection UUID
     */
    public long         uuid;

    /** 
     * Number of consumers on this connection
     */
    public int          nconsumers = 0;

    /** 
     * Number of producers on this connection
     */
    public int          nproducers = 0;

    /**
     * Remote port number
     */
    public int          remPort = 0;

    /**
     * IP address of client on the connection
     */
    public byte[]	remoteIP;

    /**
     * Metrics for connection
     */
    public MetricCounters metrics;

    /**
     * Name of user authenticated on connection. Null if not authenticated
     * by a user.
     */
    public String	user = "";

    /**
     * JMS ClientID of client on connection
     */
    public String	clientID = "";

    /**
     * User agent string
     */
    public String	userAgent = "";

    /**
     * Service this connection is connected to
     */
    public String	service = "";

    /**
     * Constructor for Consumer.
     */
    public ConnectionInfo() {
	reset();
    }

    public void reset() {
	id = null;
	remoteIP = null;
	metrics = null;
	user = "";
	clientID = "";
        service = "";
        userAgent = "";
    }


    /**
     * Return a string representation of the connection.
     * <pre>
     * dipol@client1(129.144.252.154:0)
     * </pre>
     *
     * @return String representation of connection.
     */
    public String toString() {

	return user + "@" + clientID + "(" +
	    com.sun.messaging.jmq.net.IPAddress.rawIPToString(remoteIP, true, true) + ")";
    }

}
