/*
 * @(#)SupportUtil.java	1.1 06/28/04
 *
 * Copyright 2004 Sun Microsystems, Inc. All Rights Reserved.
 *
 */

package com.sun.messaging.jmq.util;


import java.lang.StackTraceElement;

import java.lang.reflect.*;
import java.util.Hashtable;
import java.util.Vector;
import java.util.Map;
import java.util.Iterator;

public class SupportUtil
{

    public static Hashtable getAllStackTracesAsMap() {
        Hashtable ht = new Hashtable();
        try {
            Class tclass = Thread.class;
            Method m = Thread.class.getMethod("getAllStackTraces", 
                         new Class[0]);
            Map map = (Map)m.invoke(null, new Object[0]);
            Iterator itr = map.keySet().iterator();
            String retstr = "";
            while (itr.hasNext()) {
                Thread thr = (Thread)itr.next();
                StackTraceElement[] stes = (StackTraceElement[])map.get(thr);
                String name=thr + " 0x" + 
                          Long.toHexString(thr.hashCode());
                Vector value = new Vector();
                for (int i=0; i < stes.length; i ++) {
                    value.add(stes[i].toString());
                }
                ht.put(name, value);
            }
        } catch (Throwable thr) {
           ht.put("error",  "Can not getStackTrace " + thr);
            
        }
        return ht;  
    }

    public static String getAllStackTraces(String prefix) {
        try {
            Class tclass = Thread.class;
            Method m = Thread.class.getMethod("getAllStackTraces", 
                         new Class[0]);
            Map map = (Map)m.invoke(null, new Object[0]);
            Iterator itr = map.keySet().iterator();
            String retstr = "";
            while (itr.hasNext()) {
                Thread thr = (Thread)itr.next();
                StackTraceElement[] stes = (StackTraceElement[])map.get(thr);
                retstr += prefix +  thr + " 0x" + 
                          Long.toHexString(thr.hashCode()) +
                          "\n";
                for (int i=0; i < stes.length; i ++)
                    retstr += prefix + "\t" + stes[i] + "\n";
                retstr += "\n";
            }
            return retstr;  
        } catch (Throwable thr) {
           return prefix + "Can not getStackTrace " + thr;
        }

    }

}
