/*
 * @(#)Rlimit.java	1.1 02/03/20
 *
 * Copyright 2002 Sun Microsystems, Inc. All Rights Reserved
 *
 */

package com.sun.messaging.jmq.util;


/**
 * Native class that provides an interface to Unix getrlimit(2).
 *
 * @version	1.1
 *
 */
public class Rlimit {

    private static final String IMQ_NATIVE_LIBRARY = "imqutil";

    public final static int RLIMIT_CPU      = 0;    // cpu time in milliseconds
    public final static int RLIMIT_FSIZE    = 1;    // maximum file size
    public final static int RLIMIT_DATA     = 2;    // data size
    public final static int RLIMIT_STACK    = 3;    // stack size
    public final static int RLIMIT_CORE     = 4;    // core file size
    public final static int RLIMIT_NOFILE   = 5;    // file descriptors
    public final static int RLIMIT_VMEM     = 6;    // maximum mapped memory
    public final static int RLIMIT_AS       = RLIMIT_VMEM;
    public final static int RLIMIT_NLIMITS  = 7;    // number of resource limits

    public final static long RLIM_INFINITY  = -3;

    public static boolean loadFailed = true;

    static {
        try {
            System.loadLibrary(IMQ_NATIVE_LIBRARY);
            loadFailed = false;
        } catch (Throwable ex) {
            loadFailed = true;
        }
    }

    private static native Limits nativeGetRlimit(int resource);

    /**
     * Get Unix system resource limits.
     *
     * @param resource Resource to get limits for. Must be one of RLIMIT_*
     * constants.
     *
     * @return The soft and hard limits for the resource
     */
    public static Limits get(int resource) throws
        UnsupportedOperationException, IllegalArgumentException {

        if (loadFailed) {
            throw new UnsupportedOperationException();
        }

        if (resource < RLIMIT_CPU || resource == RLIMIT_NLIMITS) {
            throw new IllegalArgumentException(String.valueOf(resource));
        }

        Limits l = null;

        try {
            l = nativeGetRlimit(resource);
        } catch (Throwable e) {
            throw new UnsupportedOperationException(e.toString());
        }

        return l;
    }

    /*
     * Limits for a resource.
     */
    public class Limits {
        /* soft limit */
        public long current;

        /* hard limit */
        public long maximum;
    }
}

