/*
 * @(#)MD5.java	1.6 02/03/01
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */
/*
 * @author Shivaram Mysore
 * @version 02/03/01
 *
 */

package com.sun.messaging.jmq.util;

import java.security.*;
import java.math.BigInteger;

public class MD5 {

  public static String getHashString(String plaintext) {
      try {
      return convertToString(getHash(plaintext.getBytes("UTF8"))); 
      } catch (java.io.UnsupportedEncodingException  e) {
	  throw new RuntimeException(e.toString());
      }
  }

  public static byte[] getHash(byte[] plainText)  {
    try {      
      MessageDigest md = MessageDigest.getInstance("MD5");
      return md.digest(plainText);
    }
    catch(Exception e) {      
      throw new RuntimeException(e.toString());
    }
  }

  public static String convertToString(byte[] digest_ba) {
    return new BigInteger(digest_ba).toString(16);
  }
}
