
/*
 * @(#)DefaultTrustManager.java	1.2 07/25/05
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.management;

import javax.net.ssl.X509TrustManager;
import java.security.cert.X509Certificate;

import com.sun.messaging.jmq.util.log.Logger;

/**
 * The default trust manager.  
 *
 * TBD: Need to describe *when* this class is used i.e. what JMX configuration
 * properties trigger it's use.
 *
 * <p>If this class is used, the client does not require to install/configure
 * server certificates because all server certs are accepted.
 *
 * <p>This is useful for intra-net applications where servers are inside
 * firewall and are treated as trusted.
 */
public class DefaultTrustManager implements X509TrustManager {
    private boolean debug = false;

    public void checkClientTrusted(X509Certificate[] chain, String authType) {
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) {
        if ( debug ) {
            System.err.println("default trust manager is called to validate certs ...");
            System.err.println("returning 'true' for isServerTrusted call ...");
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}
