/*
 * @(#)Green.java	1.7 04/16/03
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */


package com.sun.messaging.jmq.jmsserver.util.memory.levels;

import com.sun.messaging.jmq.jmsserver.util.memory.*;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.*;
import com.sun.messaging.jmq.jmsserver.resources.*;
import com.sun.messaging.jmq.util.log.*;


public class Green extends MemoryLevelHandler
{

    protected static final int DEFAULT_COUNT = 50000;
    protected int MessageCount =0;

    public Green(String name) {
        super(name);
        MEMORY_NAME_KEY = BrokerResources.M_MEMORY_GREEN;
        MessageCount = Globals.getConfig().getIntProperty(
                         Globals.IMQ + "." + name + ".count", DEFAULT_COUNT);
    }

    public int getMessageCount(long freeMem, int producers) {
        return MessageCount;
    }

    public long getMemory(long freeMemory, int producers) {
        return (freeMemory - MAX_MEMORY_DELTA)/2;
    }

    public int gcCount() {
        return NEVER_GC;
    }

    public int gcIteration() {
        return NEVER_GC;
    }
}

/*
 * EOF
 */
