/*
 * @(#)MQThreadGroup.java	1.2 05/18/05
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */
package com.sun.messaging.jmq.jmsserver.util;

import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;


public class MQThreadGroup extends ThreadGroup
{

    public MQThreadGroup(String name) {
        super(name);
    }

    public void uncaughtException(Thread t, Throwable e) {
        e.printStackTrace();
        Globals.getLogger().logStack(Logger.WARNING,
                        BrokerResources.E_INTERNAL_BROKER_ERROR,
                        "Uncaught Exception in thread " + t, e);
    }

}

