/*
 * @(#)FeatureUnavailableException.java	1.2 10/08/02
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */
package com.sun.messaging.jmq.jmsserver.util;

import com.sun.messaging.jmq.jmsserver.resources.*;
import com.sun.messaging.jmq.jmsserver.Globals;

/**
 * this is the sub-class for exceptions thrown by the broker
 */

public class FeatureUnavailableException extends BrokerException
{
    String featurename = null;

    /**
     * create an exception with no message or root cause
     */
    public FeatureUnavailableException() {
        super();
    }

    /**
     * create an exception with a message but no root cause
     *
     * @param msg the failed feature
     */
    public FeatureUnavailableException(String msg) {
        super(
           (msg == null ? null :
                 Globals.getBrokerResources().getKString(
                 BrokerResources.E_FEATURE_UNAVAILABLE,
                 msg)), 
            BrokerResources.E_FEATURE_UNAVAILABLE,
            null);
        featurename = msg;
    }

    public String getFeature() {
        return featurename;
    }
}
