
package com.sun.messaging.jmq.jmsserver.service.imq.group;

import java.io.IOException;
import com.sun.messaging.jmq.util.log.*;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.*;
import com.sun.messaging.jmq.jmsserver.net.*;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.util.*;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.BrokerNotification;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.resources.*;


public class GroupServiceFactory extends IMQServiceFactory
{
    private static boolean SHARED_ALLOWED = false;

    static {
        try {
            LicenseBase license = Globals.getCurrentLicense(null);
            SHARED_ALLOWED =license.getBooleanProperty(
                       license.PROP_ENABLE_SHAREDPOOL, false);

        } catch (BrokerException ex) {
            SHARED_ALLOWED = false;
        }
    }


    public Service createService(String instancename, int type) 
        throws BrokerException
    {
        // see if we need to override properties
        if (!SHARED_ALLOWED) {

            Globals.getLogger().log(Logger.ERROR,
               BrokerResources.E_FATAL_FEATURE_UNAVAILABLE,
               Globals.getBrokerResources().getString(
                    BrokerResources.M_SHARED_THREAD_POOL)); 
            Broker.getBroker().exit(1,
               Globals.getBrokerResources().getKString(
                   BrokerResources.E_FATAL_FEATURE_UNAVAILABLE,
                   Globals.getBrokerResources().getString(
                        BrokerResources.M_SHARED_THREAD_POOL)),
               BrokerNotification.REASON_FATAL);
        }

        if (!Globals.getConfig().getBooleanProperty(Globals.IMQ +
                "." + instancename + ".override")) {
            Globals.getConfig().put(Globals.IMQ +
                "." + instancename + ".tcp.blocking", "false");
            Globals.getConfig().put(Globals.IMQ +
                "." + instancename + ".tcp.useChannels", "true");
        } else {
            Globals.getLogger().log(Logger.DEBUG,"Overriding shared properties for instance " + instancename);
       }
       return super.createService(instancename, type);

    }



    protected IMQService createService(String instancename, 
           Protocol proto, PacketRouter router, int type, 
           int min, int max)
        throws IOException
    {
        proto.configureBlocking(false);
        return new GroupService(instancename, proto, 
              type, router,  min, max);
    }

    

}
