/*
 * @(#)Operation.java	1.28 04/08/05
 *
 * Copyright 2000-2002 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.service.imq;

import java.io.*;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.log.Logger;

/**
 */


public interface Operation
{
    public static boolean DEBUG = false;
    public static int RUNNING = 0;
    public static int EXITING = 1;
    public static int DESTROYED = 2;

    public static int PROCESS_PACKETS_REMAINING = 0;
    public static int PROCESS_PACKETS_COMPLETE = 1;
    public static int PROCESS_WRITE_INCOMPLETE = 2;

    public boolean isValid();

    /**
     * a boolean which returns "true" if the operation has
     * been destroyed or is in code in which the thread can be
     * destroyed w/o any problems.
     */
    public boolean canKill();

    public void setCritical(boolean critical);

    public boolean waitUntilDestroyed(long time);

    public void destroy(boolean goodbye, int greason, String reasonstr);

    public void threadAssigned(OperationRunnable runner, int events) 
               throws IllegalAccessException;

    public void notifyRelease(OperationRunnable runner, int events);

    public void attach(NotificationInfo obj);

    public NotificationInfo attachment();
   
    // ---------------------------------------------

    public boolean process(int events, boolean wait) 
        throws IOException;

    public void wakeup();
    public void suspend();
    public void resume();

}

