/*
 * @(#)ServiceFactory.java	1.9 05/19/05
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.service;

import java.util.*;

import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;

import com.sun.messaging.jmq.jmsserver.Globals;

import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.log.Logger;

/**
 * A service handler is an abstract class which
 * handles creating services and managing their
 * resources (e.g. updating them when properties
 * change)
 */

public abstract class ServiceFactory implements ConfigListener
{

    public static boolean DEBUG = false;
    private final Logger logger = Globals.getLogger();


    ConnectionManager conmgr = null;

    public void setConnectionManager(ConnectionManager conmgr)
    {
        this.conmgr = conmgr;
    }


    public abstract Service createService(String instancename, int servicetype)
        throws BrokerException;

    public abstract void updateService(Service s)
        throws BrokerException;

    public abstract void startMonitoringService(Service s)
        throws BrokerException;

    public abstract void stopMonitoringService(Service s)   
        throws BrokerException;

    public abstract void validate(String name, String value)
        throws PropertyUpdateException;

    public abstract boolean update(String name, String value);
 
    public ConnectionManager getConnectionManager()
    {
        return conmgr;
    }

}
