/*
 * @(#)Util301To350.java	1.2 07/06/03
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL.  Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.persist.util;

import com.sun.messaging.jmq.util.log.*;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.multibroker.falcon.FalconProtocol;

import java.util.*;
import java.io.*;

/**
 * This utility class defines static methods for upgrading
 * 301 objects to the 350 format
 *
 * @version	1.2
 */
public class Util301To350 {
    private static Logger logger = Globals.getLogger();    

    public static byte[] upgradeConfigChangeRecord(byte[] olddata) {
        byte[] ret = olddata;
        try {
            ret = FalconProtocol.upgradeConfigChangeRecord(olddata);
        }
        catch (Exception e) {
            logger.logStack(logger.INFO,
                "Internal error: Bad change record. Upgrade failed.",
                e);
        }

        return ret;
    }
}

