/*
 * @(#)PropertyDAO.java	1.4 05/17/05
 *
 * Copyright 2004 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.util.BrokerException;

import java.sql.SQLException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Properties;
import java.util.List;

/**
 * This class is an interface for the Property table which will be implemented
 * by database specific code.
 *
 * @version	1.4
 */
public interface PropertyDAO extends BaseDAO {

    /**
     * Property table:
     * General purpose name/value pair. One row per property name/value pair.
     * Used to hold cluster related properties.
     *
     * CREATE TABLE MQPROP<schemaVersion>[C<clusterID>|S<brokerID>] (
     *      PROPNAME	VARCHAR(100) NOT NULL,
     *      PROPVALUE	LONGVARBINARY,
     *      PRIMARY KEY(PROPNAME)
     * );
     *
     * PROPNAME - property name
     * PROPVALUE - property value; serialized object
     */
    public static final String TABLE_NAME_PREFIX = "MQPROP" + DBConstants.SCHEMA_VERSION;
    public static final String PROPNAME_COLUMN = "PROPNAME";
    public static final String PROPVALUE_COLUMN = "PROPVALUE";

    void update( Connection conn, String name, Object value ) throws BrokerException;

    void delete( Connection conn, String name ) throws BrokerException;

    Object getProperty( Connection conn, String name ) throws BrokerException;

    List getPropertyNames( Connection conn ) throws BrokerException;

    Properties getProperties( Connection conn ) throws BrokerException;

    boolean hasProperty( Connection conn, String propName ) throws BrokerException;
}
