/*
 * @(#)ConfigRecordDAO.java	1.4 05/17/05
 *
 * Copyright 2004 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.util.BrokerException;

import java.sql.Connection;
import java.util.List;

/**
 * This class is an interface for the Configuration Change Record table
 * which will be implemented by database specific code.
 *
 * @version	1.4
 */
public interface ConfigRecordDAO extends BaseDAO {

    /**
     * Configuration Change Record table:
     * Holds change record; used by master broker only.
     *
     * CREATE TABLE MQCREC<schemaVersion>[C<clusterID>|S<brokerID>] (
     *      RECORD          LONGVARBINARY NOT NULL,
     *      CREATED_TS      BIGINT NOT NULL
     * );
     *
     * RECORD - Configuration Record
     * CREATED_TS - Timestamp when the entry was created
     */
    public static final String TABLE_NAME_PREFIX = "MQCREC" + DBConstants.SCHEMA_VERSION;
    public static final String RECORD_COLUMN = "RECORD";
    public static final String CREATED_TS_COLUMN = "CREATED_TS";

    void insert( Connection conn, byte[] recordData, long timeStamp )
        throws BrokerException;

    List getRecordsSince( Connection conn, long timestamp ) throws BrokerException;

    Object[] getAllRecords( Connection conn ) throws BrokerException;
}
