/*
 * @(#)LoadException.java	1.1 06/08/04
 *
 * Copyright 2004 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsserver.persist;

import com.sun.messaging.jmq.jmsserver.util.BrokerException;

/**
 * This class provides information about problems and/or data corruptions
 * encountered when loading data from persistent store.
 * If the key and/or the value of the hash map entry is loaded successfully,
 * it can be retrieved by calling <code>getKey()</code> and/or
 * <code>getValue</code> respectively. The throwable caught while
 * deserializing the key can be retrieved by calling
 * <code>getKeyCause()</code>. Similarly, the throwable caught while
 * deserializing the value can be retrieved by calling
 * <code>getValueCause()</code>. Other exception caught while parsing
 * the record, if any, can be retrieved by <code>getCause</code>.
 * <code>getNextException()</code> returns
 * the next chained exception for other loading problems or
 * <code>null</code> if there's no more chained exception.
 *
 *
 * @version     1.1
 */

public class LoadException extends BrokerException {

    private Object key = null;
    private Object value = null;
    private LoadException next = null;
    private Throwable keyCause = null;
    private Throwable valueCause = null;

    /**
     * Constructs a LoadException
     */ 
    public LoadException(String msg, Throwable t) {
        super(msg, t);
    }

    public void setKey(Object k) {
	this.key = k;
    }

    /**
     * The key of the HashMap entry loaded from file.
     */
    public Object getKey() {
	return key;
    }

    public void setValue(Object v) {
	this.value = v;
    }

    /**
     * The value of the HashMap entry loaded from file.
     */
    public Object getValue() {
	return value;
    }

    public void setKeyCause(Throwable t) {
	this.keyCause = t;
    }

    /**
     * Return the Throwable caught while loading the key.
     */
    public Throwable getKeyCause() {
	return this.keyCause;
    }

    public void setValueCause(Throwable t) {
	this.valueCause = t;
    }

    /**
     * Return the Throwable caught while loading the key.
     */
    public Throwable getValueCause() {
	return this.valueCause;
    }

    public void setNextException(LoadException e) {
	this.next = e;
    }

    /**
     * Return the exception chained to this object.
     */
    public LoadException getNextException() {
	return next;
    }

    public String toString() {
	return getMessage() + "\nkey="+key+";cause="+keyCause+";value="+value
			+";cause="+valueCause;
    }
}
