/*
 * @(#)TLSProtocol.java	1.41 05/09/08
 *
 * Copyright 2000-2002 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsserver.net.tls;

import java.io.*;
import java.net.*;
import java.security.cert.*;
import java.security.KeyStore;
import java.security.SecureRandom;

import javax.net.*;
import javax.net.ssl.*;
import javax.security.cert.X509Certificate;

import com.sun.messaging.jmq.jmsserver.net.*;
import com.sun.messaging.jmq.jmsserver.net.tcp.TcpProtocol;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.net.MQServerSocketFactory;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.BrokerNotification;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.util.StringUtil;
import com.sun.messaging.jmq.util.Password;
import com.sun.messaging.jmq.jmsserver.resources.*;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.util.*;

/**
 * This class handles a TLS (SSL) type of protocol.
 *
 * @author Shivaram Mysore
 * @version 05/09/08
 *
 */

public class TLSProtocol extends TcpProtocol {

    public static boolean DEBUG = false;

    private static final int defaultPort    = 11001;

    protected static boolean TLS_ALLOWED = false;

    // generated once when the first server socket is needed
    private static ServerSocketFactory ssfactory = null;

    protected static Logger logger = Globals.getLogger();
    protected static BrokerResources br = Globals.getBrokerResources();

    private ServerSocket serversocket = null;      

    static {
	try {
	    LicenseBase license = Globals.getCurrentLicense(null);
	    TLS_ALLOWED = license.getBooleanProperty(
				license.PROP_ENABLE_SSL, false);
	} catch (BrokerException ex) {
	    TLS_ALLOWED = false;
	}

    }

    // needed for inprocess
    public static void init() {
        logger = Globals.getLogger();
        br = Globals.getBrokerResources();
    }

    // needed for inprocess
    public static void destroy() {
        ssfactory = null;
        Logger logger = null;
        br = null;
    }

    /*
     * Empty Constructor
     */

    public TLSProtocol() {	
        CanChangeBlocking = false; // dont let us block
        port = defaultPort;

	if (!TLS_ALLOWED) {
	    Globals.getLogger().log(Logger.ERROR,
			BrokerResources.E_FATAL_FEATURE_UNAVAILABLE,
			Globals.getBrokerResources().getString(
				BrokerResources.M_SSL_JMS));
	    Broker.getBroker().exit(1,
                 Globals.getBrokerResources().getKString(
                        BrokerResources.E_FATAL_FEATURE_UNAVAILABLE,
                        Globals.getBrokerResources().getString(
                                BrokerResources.M_SSL_JMS)),
                 BrokerNotification.REASON_FATAL);
	}
    }


    public ProtocolStreams accept()  throws IOException {
	if (serversocket == null)  {	 
	    throw new IOException(Globals.getBrokerResources().getString(
                BrokerResources.X_INTERNAL_EXCEPTION,
                "Unable to accept on un-opened protocol"));
	}
	SSLSocket s = (SSLSocket)serversocket.accept();
        s.setTcpNoDelay(nodelay);
	TLSStreams streams = createConnection(s);
	return streams;
	
    }
    
 

    public String toString() {
        return "SSL/TLS [ " + port + "," + backlog + "]";
    }

    protected ServerSocket createSocket(String hostname, int port,
                            int backlog, boolean blocking, boolean useChannel) 
	throws IOException  { 
//ignore blocking and useChannel (they wont work)
	    /*
	     * Dynamic registration of JSSE provider 
	     * If this is not done, then add the line :
	     *      security.provider.2=com.sun.net.ssl.internal.ssl.Provider
	     * to the $JAVA_HOME/jre/lib/security/java.security file
	     * 
	     * By Dynamically registering this here, it is not necessary to 
	     * modify the java.security file as mentioned.
	     *
	     */
        registerSSLProvider();

	ServerSocketFactory ssf = getServerSocketFactory();	
        if (hostname != null && !hostname.equals(Globals.HOSTNAME_ALL)) {
            InetAddress endpoint = InetAddress.getByName(hostname);

	    serversocket = ssf.createServerSocket(port, backlog, endpoint);
        } else {    
	    serversocket = ssf.createServerSocket(port, backlog);
        }

        if (DEBUG && serversocket != null) {
                logger.log(Logger.DEBUG,
                "TLSProtocol: " + serversocket + " " +
                MQServerSocketFactory.serverSocketToString(serversocket) +
                ", backlog=" + backlog +
                "");
        }
	    
	return serversocket;
    }
    
    protected TLSStreams createConnection(SSLSocket socket)  
        throws IOException
    {
        return new TLSStreams((SSLSocket)socket,
            inputBufferSize, outputBufferSize);
    }

    public static ServerSocketFactory getServerSocketFactory()
	throws IOException {

        synchronized (classlock) {

	  if (ssfactory == null) {

	    // need to get a SSLServerSocketFactory
	    try {
	    
		// set up key manager to do server authentication
		// Don't i18n Strings here.  They are key words
		SSLContext ctx;
		KeyManagerFactory kmf;
		KeyStore ks;		

		// Get Keystore location
		String keystore_location = KeystoreUtil.getKeystoreLocation();

		// Got Keystore full filename 

		// Check if the keystore exists.  If not throw exception.
		// This is done first as if the keystore does not exist, then
		// there is no point in going further.
	    	   
		File kf = new File(keystore_location);	
		if (kf.exists()) {
		    // nothing to do for now.		
		} else {
		    throw new IOException(
			br.getKString(BrokerResources.E_KEYSTORE_NOT_EXIST,
					keystore_location));
		}	

		/*
		 * Get passphrase
		 */
		String pass_phrase = KeystoreUtil.getKeystorePassword();

		// Got Passphrase. 
 	    
		if (pass_phrase == null) {
		    // In reality we should never reach this stage, but, 
		    // just in case, a check		
		    pass_phrase = new String();
		    logger.log(Logger.ERROR, br.getKString(
					BrokerResources.E_PASS_PHRASE_NULL));
		}
	    
		char[] passphrase = pass_phrase.toCharArray();

		// Magic key to select the TLS protocol needed by JSSE
		// do not i18n these key strings.
		ctx = SSLContext.getInstance("TLS");
		kmf = KeyManagerFactory.getInstance("SunX509");  // Cert type
		ks = KeyStore.getInstance("JKS");  // Keystore type

		ks.load(new FileInputStream(keystore_location), passphrase);
		kmf.init(ks, passphrase);
	    
		TrustManager[] tm = new TrustManager[1];
		tm[0] = new DefaultTrustManager();
	    
		// SHA1 random number generator
		SecureRandom random = SecureRandom.getInstance("SHA1PRNG");  
	    
		ctx.init(kmf.getKeyManagers(), tm, random);

		//ssfactory = ctx.getServerSocketFactory();
                ssfactory = MQServerSocketFactory.wrapFactory(
                                                ctx.getServerSocketFactory());
	    } catch (IOException e) {
        	throw e;
            } catch (Exception ex) {
		logger.logStack(Logger.ERROR, 
		        br.getKString(BrokerResources.X_GET_SSL_SOCKET_FACT), 
		        ex);
        	throw new IOException(ex.getMessage());
	    }			    
	  } // if (ssfactory == null)


	  return ssfactory;
	}
    }
    
    /**
     * Although Security.addProvider() checks if the provider already
     * registered,  the registered check here saves a new instance creation
     */
    public static void registerSSLProvider() {
        if (!registered) { 
            synchronized (classlock) {
                if (!registered) {
                java.security.Provider p =
                                new com.sun.net.ssl.internal.ssl.Provider(); 
                java.security.Security.addProvider(p);
                registered = true;
                }
            }
        }
    }
    private static boolean registered = false;
    private static final Object classlock = new Object();
}
