/*
 * @(#)DefaultTrustManager.java	1.6 02/04/12
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsserver.net.tls;


import java.security.cert.*;
import javax.security.cert.X509Certificate;
import javax.net.ssl.*;

import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.jmsserver.Globals;

/**
 * DefaultTrustManager to manage authentication trust decisions for 
 * different types of authentication material.  Here X509TrustManager is 
 * implemented as the keystore is of type JKS which contains certificates
 * of type X509.
 *
 * X509TrustManager is an interface to manage which X509 certificates which
 * are used to authenticate the remote side of a secure socket. Decisions may
 * be based on trusted certificate authorities, certificate revocation lists,
 * online status checking or other means. 
 * 
 * Currently contains some dummy methods.  This should be sufficient for 
 * the 2.0 product.
 *
 * @see java.security.cert.X509TrustManager
 *
 */

public class DefaultTrustManager implements X509TrustManager {

    public static  boolean DEBUG = false;
    Logger logger = Globals.getLogger();

    public void checkClientTrusted(java.security.cert.X509Certificate[] chain) {
        return;
    }

    public void checkClientTrusted(java.security.cert.X509Certificate[] chain,
				String type) {
        return;
    }
    
    public void checkServerTrusted(java.security.cert.X509Certificate[] chain) { 
        if (DEBUG) {
	    logger.log(Logger.DEBUGHIGH,"DefaultTrustManager called to validate certs ..");
	    logger.log(Logger.DEBUGHIGH,"returning 'true' for isServerTrusted call ...");
        }
        return;
    }

    public void checkServerTrusted(java.security.cert.X509Certificate[] chain,
			String type) { 
        if (DEBUG) {
	    logger.log(Logger.DEBUGHIGH,"DefaultTrustManager called to validate certs ..");
	    logger.log(Logger.DEBUGHIGH,"returning 'true' for isServerTrusted call ...");
        }
        return;
    }

    public java.security.cert.X509Certificate[] getAcceptedIssuers() {
        return new java.security.cert.X509Certificate[0];
    }
}
