/*
 * @(#)ClusterImpl.java	1.15 11/23/05
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.multibroker.standalone;

import java.util.*;
import java.io.*;
import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;


/**
 * This class implements the 'standalone' topology.
 */
public class ClusterImpl implements Cluster, ConfigListener {
    ClusterCallback cb = null;
    private BrokerAddressImpl self;

    /**
     * Creates and initializes a topology manager for the two broker
     * topology using the broker configuration.
     */
    public ClusterImpl() {
        self = new BrokerAddressImpl();
    }

    public void setCallback(ClusterCallback cb) {
        this.cb = cb;
    }

    public void useGPackets(boolean useGPackets) {
    }

    public void setMatchProps(Properties matchProps) {
    }

    public void start() {
    }

    public void shutdown() {
    }

    public void closeLink(BrokerAddress remote, boolean force) {
    }

    public boolean isReachable(BrokerAddress remote, int timeout) throws IOException {
        return true;
    }

    public BrokerAddress getSelfAddress() {
        return (BrokerAddress) self;
    }

    public BrokerAddress getConfigServer() throws BrokerException {
        return null;
    }

    public void marshalBrokerAddress(BrokerAddress ddr, GPacket gp) {
    }

    public BrokerAddress unmarshalBrokerAddress(GPacket gp) throws Exception {
        return null;
    }
 

    public void stopMessageFlow() throws IOException {
    }

    public void resumeMessageFlow() throws IOException {
    }

    public void unicastAndClose(BrokerAddress addr, GPacket gp) throws IOException {
        if (cb != null) cb.receiveUnicast(self, gp);
    }

    public void unicast(BrokerAddress addr, GPacket gp, boolean flowControl)
        throws IOException {
        if (cb != null) cb.receiveUnicast(self, gp);
    }

    public void unicast(BrokerAddress addr, GPacket gp) throws IOException {
        unicast(addr, gp, false);
    }

    public void broadcast(GPacket gp) throws IOException {
    }

    public void unicast(BrokerAddress addr, int destId, byte[] pkt,
        boolean flowControl) throws IOException {
        if (cb != null)
            cb.receiveUnicast(self, destId, pkt);
    }

    public void unicast(BrokerAddress addr, int destId, byte[] pkt)
        throws IOException {
        unicast(addr, destId, pkt, false);
    }

    public void broadcast(int destId, byte[] pkt) {
    }

    public boolean election(int electionId, byte[] params) {
        return true;
    }

    public void reloadCluster() {
    }

    /**
     * Dynamic configuration property validation..
     */
    public void validate(String name, String value)
        throws PropertyUpdateException {
    }

    /**
     * Dynamic configuration property updation..
     */
    public boolean update(String name, String value) {
        return true;
    }
}

/*
 * EOF
 */
