/*
 * @(#)RemDurableHandler.java	1.5 03/22/05
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import java.io.*;
import java.util.Iterator;
import com.sun.messaging.jmq.util.*;
import com.sun.messaging.jmq.jmsserver.util.*;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.jmsserver.core.*;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.*;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;

public class RemDurableHandler extends GPacketHandler {
    public static boolean DEBUG = false;

    public RemDurableHandler(RaptorProtocol p) {
        super(p);
    }

    public void handle(MessageBusCallback cb, BrokerAddress sender, GPacket pkt) {
        if (DEBUG)
            logger.log(logger.DEBUG, "RemDurableHandler");

        if (pkt.getType() == ProtocolGlobals.G_REM_DURABLE_INTEREST) {
            handleRemDurableInterest(cb, sender, pkt);
        }
        else if (pkt.getType() ==
            ProtocolGlobals.G_REM_DURABLE_INTEREST_REPLY) {
            handleRemDurableInterestAck(sender, pkt);
        }
        else {
            logger.log(logger.WARNING, "RemDurableHandler " +
                "Internal error : Cannot handle this packet :" +
                pkt.toLongString());
        }
    }

    public void handleRemDurableInterest(MessageBusCallback cb, BrokerAddress sender, GPacket pkt) {

        ClusterSubscriptionInfo csi = ClusterSubscriptionInfo.newInstance(pkt);

        if (p.getConfigSyncComplete() == false && !csi.isConfigSyncResponse()) {
            // Do not accept the normal interest updates before
            // config sync is complete. Here is 
            if (DEBUG) {
                logger.log(logger.DEBUG,
                    "MessageBus: Dropping the G_REM_DURABLE_INTEREST " +
                    "packet from {0}. Not ready yet.", sender);
            }
            return;
        }

        int count = ((Integer)pkt.getProp("C")).intValue();
        Iterator itr = csi.getSubscriptions();
        try {
            while(itr.hasNext()) {
                Subscription intr = (Subscription)itr.next();
                if (intr != null) {
                    cb.unsubscribe(intr);
                }
            }
        }
        catch (Exception e) { 
           logger.logStack(logger.DEBUG,"Exception processing packet ", e);
        } 

        if (csi.needReply()) {
            GPacket gp = ClusterSubscriptionInfo.getReplyGPacket(
                                                ProtocolGlobals.G_REM_DURABLE_INTEREST_REPLY,
                                                ProtocolGlobals.G_SUCCESS);
            try {
                c.unicast(sender, gp);
            }
            catch (IOException e) {}
        }
    }

    private void handleRemDurableInterestAck(BrokerAddress sender,
        GPacket pkt) {
        logger.log(logger.DEBUG,
            "MessageBus: Received G_REM_DURABLE_INTEREST_REPLY " +
            "from {0} : STATUS = {1}",
            sender, ((Integer) pkt.getProp("S")));
    }
}


/*
 * EOF
 */
