/*
 * @(#)NewInterestHandler.java	1.10 05/20/05
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import java.io.*;
import java.util.Iterator;
import com.sun.messaging.jmq.util.*;
import com.sun.messaging.jmq.jmsserver.util.*;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.jmsserver.core.*;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.*;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;

public class NewInterestHandler extends GPacketHandler {
    public static boolean DEBUG = false;

    public NewInterestHandler(RaptorProtocol p) {
        super(p);
    }

    public void handle(MessageBusCallback cb, BrokerAddress sender, GPacket pkt) {
        if (DEBUG)
            logger.log(logger.DEBUG, "NewInterestHandler");

        if (pkt.getType() == ProtocolGlobals.G_NEW_INTEREST) {
            handleNewInterest(cb, sender, pkt);
        }
        else if (pkt.getType() == ProtocolGlobals.G_NEW_INTEREST_REPLY) {
            handleNewInterestAck(sender, pkt);
        }
        else if (pkt.getType() == ProtocolGlobals.G_DURABLE_ATTACH) {
            handleAttachDurable(cb, sender, pkt);
        }
        else if (pkt.getType() == ProtocolGlobals.G_DURABLE_ATTACH_REPLY) {
            handleAttachDurableReply(sender, pkt);
        }
        else {
            logger.log(logger.WARNING, "MessageDataHandler " +
                "Internal error : Cannot handle this packet :" +
                pkt.toLongString());
        }
    }

    public void handleNewInterest(MessageBusCallback cb, BrokerAddress sender, GPacket pkt) {
        if (DEBUG) {
            logger.log(logger.DEBUG, "handleNewInterest from : " + sender);
        }

		ClusterConsumerInfo cci = ClusterConsumerInfo.newInstance(pkt, c);

        if (p.getConfigSyncComplete() == false && !cci.isConfigSyncResponse()) {
            // Do not accept the normal interest updates before
            // config sync is complete. Here is 
            if (DEBUG) {
                logger.log(logger.DEBUG,
    "MessageBus: Dropping the  ClusterGlobals.MB_INTEREST_UPDATE. Not ready yet.");
            }
            return;
        }

        int count = cci.getConsumerCount();
        if (DEBUG) {
            logger.log(logger.DEBUG, "handleNewInterest count : " + count);
        }

        try {
            Iterator itr = cci.getConsumers();
            while (itr.hasNext()) {
                Consumer cons = (Consumer)itr.next();

                // Make sure that the destination exists...
                DestinationUID duid = cons.getDestinationUID();
                int type = (duid.isQueue() ? DestType.DEST_TYPE_QUEUE : DestType.DEST_TYPE_TOPIC);
                Destination dest = Destination.getDestination(duid.getName(), type, true, true);

                cb.interestCreated(cons);
            }
        }
        catch (Exception e) { 
            logger.logStack(logger.DEBUG,"Exception processing packet ", e);
        }

        if (cci.needReply()) {
            GPacket gp = ClusterConsumerInfo.getReplyGPacket(
                                ProtocolGlobals.G_NEW_INTEREST_REPLY,
                                            ProtocolGlobals.G_SUCCESS);
            try {
                c.unicast(sender, gp);
            }
            catch (IOException e) {}
        }
    }

    private void handleNewInterestAck(BrokerAddress sender, GPacket pkt) {
        logger.log(logger.DEBUG,
"MessageBus: Received G_NEW_INTEREST_REPLY from {0} : STATUS = {1}",
            sender, ((Integer) pkt.getProp("S")));
    }

    public void handleAttachDurable(MessageBusCallback cb, BrokerAddress sender, GPacket pkt) {
        if (DEBUG) {
            logger.log(logger.DEBUG, "handleAttachDurable from : " + sender);
        }

        ClusterSubscriptionInfo csi = ClusterSubscriptionInfo.newInstance(pkt, c);
        try {
            String dname = csi.getDurableName();
            String cid = csi.getClientID();

            // if we receive a packet which does not support
            // shared subscriptions -> we are dealing with an
            // older (e.g. 3.5) broker .. so we should never
            // have a null durable name
            Boolean allowsNonDurable = csi.allowsNonDurable(); 

            boolean nonDurableOK = (allowsNonDurable == null
                         ? false : allowsNonDurable.booleanValue());

            // check if anything is bogus in the paclet
            if (cid == null || (!nonDurableOK  && dname == null)) {
                logger.log(logger.INFO,
                    "Internal Error in handleAttachDurable : " +
                    dname + ":" + cid);
                return;
            }

            Consumer cons = csi.getConsumer();

            Subscription sub = null;

            if (dname == null) { // non-durable shared subscription
                DestinationUID duid = cons.getDestinationUID();
                String selector = cons.getSelectorStr();
                sub = Subscription.findNonDurableSubscription(
                    cid, duid, selector);
            } else {
                sub = Subscription.findDurableSubscription(
                    cid, dname);
            }

            if (sub == null) {
                logger.log(logger.INFO,
                    "Internal Error in handleAttachDurable. " +
                    " Subscription not found : " + dname + ":" + cid);
                return;
            }

            try {
                sub.attachConsumer(cons);
                cb.interestCreated(cons);
            } catch (Exception ex) {
                logger.logStack(logger.INFO, "Internal Error: Unable to"+
                       " attach consumer " , ex);
            }

        }
        catch (Exception e) {
            logger.logStack(logger.DEBUG,"Exception processing packet ", e);
        }

        if (csi.needReply()) {
            GPacket gp = ClusterSubscriptionInfo.getReplyGPacket(
                                         ProtocolGlobals.G_DURABLE_ATTACH_REPLY,
                                                       ProtocolGlobals.G_SUCCESS);
            try {
                c.unicast(sender, gp);
            }
            catch (IOException e) {}
        }
    }

    private void handleAttachDurableReply(BrokerAddress sender, GPacket pkt) {
        logger.log(logger.DEBUG,
"MessageBus: Received G_DURABLE_ATTACH_REPLY from {0} : STATUS = {1}",
            sender, ((Integer) pkt.getProp("S")));
    }
}


/*
 * EOF
 */
